#include <string.h>
#include <stdio.h>
#include <time.h>
#include "config.h"

/*
  PROCEDURE read_file( list, filename )
  INPUTS:
     list        a pointer to a list structure
     filename    a pointer to a string
  REQUIRES:
     each line in the file consists of a string followed by a number.
     The string and number may be separated by any number of spaces or
     tabs.
  MODIFIES:
     list
  EFFECTS:
     Reads a list of file records from the file.
     Stores the entries in the list in sequential order.
     Modifies list->num_entries so that it is the number of entries in the
     list.  If there are more lines of text in the file than MAX_F_LINES,
     the procedure ignores the extra lines.
*/

void read_file( list, filename )
     struct list_rec *list;
     char *filename;
{
  int i = 0;
  FILE *the_file;
  char line[BUFLEN];
  char *token;

  /* Open the file */
  if ( DEBUG )
    printf( "PROC read_file: attempting to open file %s.\n", filename );
  if ( ( the_file = fopen( filename, "r" ) ) == NULL )
    {
      printf( "Couldn't open file %s.\n", filename );
      exit ( 1 );
    }
  if ( DEBUG )
    printf( "PROC read_file: successfully opened file %s.\n", filename );
  
  /* Read the lines of the file into the list */
  while ( ( fgets( line, BUFLEN, the_file ) != NULL ) &&
	  ( i < MAX_F_LINES ) )
    {
      if ( ( token = strtok( line, " \t\n" ) ) != NULL )
	{
	  strcpy( ( list->entry )[i].text, token );
	  ( list->entry )[i].num = atoi( strtok( NULL, " \t\n" ) );
	  i++;
	}
    }

  fclose( the_file );
  list->num_entries = i;
}


/*
  PROCEDURE write_file( list, filename )
  INPUTS:
     list       a pointer to a list structure
     filename   a pointer to a string
  EFFECTS:
     writes the list to the file.  The format of each line in the file is
     the text, which is followed by three tabs and then the number.
*/

void write_file( list, filename )
     struct list_rec *list;
     char *filename;
{
  int i = 0;
  FILE *the_file;
  char line[BUFLEN];

  /* Open the file */
  if ( DEBUG )
    printf( "PROC write_file: attempting to open file %s.\n", filename );
  if ( ( the_file = fopen( filename, "w" ) ) == NULL )
    {
      printf( "Couldn't open file %s.\n", filename );
      exit ( 1 );
    }

  /* Write the list into the file */
  while ( i < ( list->num_entries ) )
    {
      sprintf( line, "%s\t\t\t%d\n", ( list->entry )[i].text,
	       ( list->entry )[i].num );
      if ( fputs( line, the_file ) == NULL )
	{
	  printf( "Encountered difficulty writing to file %s\n.", filename );
	  exit( 1 );
	}
    }
}







