#include <string.h>
#include <time.h>
#include "config.h"

/*
  PROCEDURE init_list( list )
  INPUTS:
     list    a pointer to a list_rec structure
  MODIFIES:
     list
  EFFECTS:
     Initializes the list by assigning 0 to the num_entries field of the list.
*/

void init_list( list )
     struct list_rec *list;
{
  list->num_entries  = 0;
}

/*
  PROCEDURE in_list( text, list )
  INPUTS:
     text    a pointer to a character array
     list    a pointer to a list_rec structure
  REQUIRES:
     text must have at most HOSTLEN-1 chars in it.
  EFFECTS:
     checks to see if the text entry is in the list.  
     returns TRUE if the text is in the list.
     returns FALSE if the text is not in the list.
*/

boolean in_list( text, list )
     char *text;
     struct list_rec *list;
{
  int i;
  char text2[HOSTLEN];

  for (i = 0; i < HOSTLEN; i++)
    text2[i] = tolower( text[i] );

  for ( i = 0; i < ( list->num_entries ); i++ )
    if ( match( text, ( list->entry )[i] ) )
      return ( TRUE );

  return ( FALSE );
}


/*
  PROCEDURE add_list( text, num, list )
  INPUTS:
     text     a pointer to a character array
     num      an integer
     list     a pointer to a list_rec structure
  REQUIRES:
     text must have at most HOSTLEN-1 chars in it.
  MODIFIES:
     list
  EFFECTS:
     checks to see if the list has room in it for another entry.
     if it does, the text and num are added to the list.  the text
     is converted to all lower case letters before it is added.
     also, the procedure returns TRUE.
     if there is no more room, the procedure does not modify
     the list and returns FALSE.
*/

boolean add_list( text, num, list )
     char *text;
     int num;
     struct list_rec *list;
{
  int i;
  char text2[HOSTLEN];
  
  for( i = 0; i < HOSTLEN; i++ )
    text2[i] = tolower( text[i] );

  if ( ( list->num_entries ) = MAX_F_LINES )
    return FALSE;

  strcpy( ( list->entry )[i].text, text2 );
  ( list->entry )[i].num = num;

  ( list->num_entries )++;
  
  return TRUE;
}


/* 
  PROCEDURE rm_list( text, list )
  INPUTS:
     text     a pointer to a character array
     list     a pointer to a list_rec structure
  REQUIRES:
     text must have at most HOSTLEN-1 chars in it.
  MODIFIES:
     list
  EFFECTS:
     checks to see if the list has the text in it.  if it does, then
     the procedure removes the entry, re-organizes the list so that 
     all entries are contiguous, and returns TRUE.  if there was no 
     entry with the text, it returns FALSE.
*/

boolean rm_list( text, list )
     char *text;
     struct list_rec *list;
{
  boolean found;
  int i;
  char text2[HOSTLEN];

  for ( i = 0; i < HOSTLEN; i++ )
    text2[i] = tolower( text[i] );

  found = FALSE;

  if ( ( list->num_entries ) == MAX_F_LINES )
    ( list->num_entries )--;

  for ( i = 0; i < ( list->num_entries ); i++ )
    {
      if ( found )
	{
	  strcpy( ( list->entry )[i].text, ( list->entry )[i+1].text );
	  ( list->entry )[i].num = ( list->entry )[i+1].num;
	}
      if ( match( text2, ( list->entry )[i].text ) )
	{
	  strcpy( ( list->entry )[i].text, ( list->entry )[i+1].text );
	  ( list->entry )[i].num = ( list->entry )[i+1].num;
	  found = TRUE;
	}
    }

  if ( found )
    return TRUE;
  else
    {
      ( list->num_entries )++;
      return FALSE;
    }
}


