#include <ctype.h>
#include <string.h>
#include <time.h>
#include "config.h"

/* 
  PROCEDURE: match( pattern1, pattern2 )
  INPUT:
     pattern1  a pointer to a character array
     pattern2  a pointer to a character array
  REQUIRES:
     pattern1 and pattern2 should be in all lowercase or all uppercase
     letters for this procedure to work.
  EFFECTS:
     returns TRUE if pattern1 and pattern2 match according to the rules that
     '*' is a true wild-card and that '?' is a one character wildcard.
     if they don't match, this procedure returns FALSE.

  NOTE:
     the main body of match was taken from the match.c file in
     the source code for the irc client version 2.2.7pre1.  The 
     original match checked a string vs. a pattern.  I modified this
     code to check a pattern vs. another pattern.
*/
     
int match(char *pattern1, char *pattern2)
{
  
  while ( *pattern1 && *pattern2 && 
	  ( *pattern1 != '*' ) &&
	  ( *pattern2 != '*' ) )
    {
      if ( ( *pattern1 == '?' ) || 
	   ( *pattern1 == ( *pattern2 ) ) ||
	   ( *pattern2=='?' ) )
	pattern1++, pattern2++;
      else
	break;
    }
  if ( *pattern1 == '*' )
    {
      pattern1++;
      while ( *pattern2 )
	{
	  if ( match( pattern1, pattern2 ) )
	    return TRUE;
	  else
	    pattern2++;
	}
    }
  if ( *pattern2=='*' )
    {
      pattern2++;
      while ( *pattern2 )
	{
	  if ( match ( pattern1, pattern2 ) )
	    return TRUE;
	  else
	    pattern1++;
	}
    }
  if ( !*pattern1 && !*pattern2 )
    return TRUE;
  return FALSE;
}
