#include <stdio.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include "config.h"
#include "newbot.h"

/*
  PROCEDURE void init_bots ( botarray )
  INPUTS:
     botarray   a pointer to an array of botrecs
  MODIFIES:
     botarray
  EFFECTS:
     initializes all of the bots so that:
        1) sockfd = -1
        2) nick = ""
	3) userid = ""
	4) ircname = ""
	5) alive = FALSE
	6) leader = FALSE
	7) is_op = FALSE
	8) onjoin = FALSE
	9) revon = FALSE
	10) onchan = FALSE
	11) channel = ""
	12) for 0<=i<MAX_CHAN_POP, chan_nicks = ""
	13) num_nicks = 0
*/

void init_bots( botarray )
     struct botrec *botarray;
{
  int i, j;

  for ( i = 0; i < MAXBOTS; i++ )
    {
      botarray[i].sockfd = -1;

      strcpy( botarray[i].nick, "" );
      strcpy( botarray[i].userid, "" );
      strcpy( botarray[i].ircname, "" );

      botarray[i].alive = FALSE;
      botarray[i].leader = FALSE;
      botarray[i].is_op = FALSE;
      botarray[i].onjoin = FALSE;
      botarray[i].revon = FALSE;
      botarray[i].onchan = FALSE;

      botarray[i].last_time = 0;
      
      strcpy( botarray[i].channel, "" );
    }
}

/*
  PROCEDURE void kill_bot ( botnum, botarray, usedfds )
  INPUTS
     botnum     a number for the bot
     botarray   a pointer to an array of botrecs
     usedfds    a pointer to the socket fds which are being used
  REQUIRES
     botnum < MAXBOTS
  MODIFIES
     botarray, usefds
  EFFECTS
     closes the socket of the bot and sets its alive field to be FALSE
     also clears the sockfd from the usedfds structure.
*/

void kill_bot( botnum, botarray, usedfds )
     int botnum;
     struct botrec *botarray;
     fd_set *usedfds;
{
  if ( botarray[botnum].alive )
    {
      botarray[botnum].alive = FALSE;
      close( botarray[botnum].sockfd );
      FD_CLR( botarray[botnum].sockfd, usedfds );
    }
}

/*
  PROCEDURE int new_bot ( botarray, nick, userid, ircname, leader,
                          servlist, usedfds, highfd ) 
  INPUTS:
     botarray   a pointer to an array of botrec structures
     nick       the nick of the newbot
     userid     the userid for the newbot
     leader     a boolean which determines whether the bot becomes the leader
                bot
     servlist   a pointer to a list of possible servers and ports to which
                a bot can connect. 
     usedfds    a set of fds for sockets which are being used
     highfd     the highest socket fd which is in usedfds.
  REQUIRES:
     if leader == TRUE, then there must be no other leader bots alive.
     otherwise, leader must equal FALSE
  MODIFIES:
     botarray
     usedfds
     highfd
  EFFECTS:
     if all the bots are alive or if no new sockets can be opened, then it 
     returns NO_NEW_BOT and does not create a new bot.  if one of the bots is 
     not alive, then it starts a bot and returns NEW_BOT.  If a bot is started,
     its socket fd is added to usedfds.  Also if the new socketfd is higher
     than the highfd, the highfd is assigned the value of the new socket fd.
*/

int new_bot ( botarray, nick, userid, ircname, leader, servlist, 
	      usedfds, highfd )
     struct botrec *botarray;
     char *nick;
     char *userid;
     char *ircname;
     boolean leader;
     struct list_rec *servlist;
     fd_set *usedfds;
     int *highfd;
{
  int i, start;
  int sockfd, curr_bot;
  char line[BUFLEN];

  /* Find the first dead bot */
  if ( DEBUG )
    printf( "PROC new_bot: finding the first dead bot.\n" );
  for ( curr_bot = 0; ( botarray[curr_bot].alive ) && ( curr_bot < MAXBOTS );
        curr_bot++ );

  /* All bots are alive.  No new bots can be made */
  if ( ( curr_bot == ( MAXBOTS ) ) && ( botarray[curr_bot-1].alive ) )
    {
      if ( DEBUG )
	printf ( "PROC new_bot: all the bots are alive.\n" );
      return NO_NEW_BOT;
    }

  /* Initialize a new bot */
  strcpy( botarray[curr_bot].nick, nick );
  strcpy( botarray[curr_bot].userid, userid );
  strcpy( botarray[curr_bot].ircname, ircname );
  botarray[curr_bot].leader = leader;
  
  /* Attempt to establish a connection to a server */
  if ( DEBUG )
    printf ( "PROC new_bot: attempting to establish a socket connection.\n" );
  start = rand() % ( servlist->num_entries );
  i = ( start + 1 );
  while ( ( ( i != start ) || ( ( servlist->num_entries ) == 1 ) ) 
	  && 
	  ( ( sockfd = get_socket( ( servlist->entry )[i].text,
				   ( servlist->entry )[i].num ) ) < 0) )
    {
      printf( "Failed attempt to connect %s to server %s.\n", nick, 
	      ( servlist->entry )[i].text );
      i = ( i + 1 ) % ( servlist->num_entries );
    }

  /* Check if a socket connection was established */
  if ( DEBUG )
    printf ("PROC new_bot: checking if socket connection was established.\n");
  if ( ( i == start ) && ( sockfd < 0 ) )
    {
      if ( DEBUG )
	{
	  printf ( "PROC new_bot: Not all bots are alive.\n" );
	  printf ( "PROC new_bot: A socket could not be opened.\n");
	}
      return NO_NEW_BOT;
    }

  /* The bot has been connected */
  printf( "%s successfully connected to server %s.\n", nick, 
	  ( servlist->entry )[i].text );
  botarray[curr_bot].sockfd = sockfd;
  botarray[curr_bot].alive = TRUE;

  FD_SET( sockfd, usedfds );

  /* Sending the userid, username, and the nick of the bot. */
  if ( DEBUG )
    printf( "PROC new_bot: sending the userid and ircname to the server.\n");
  sprintf( line, "user %s f f %s\n", userid, ircname );
  writeln( sockfd, line, strlen( line ) );

  if ( DEBUG ) 
    printf( "PROC new_bot: sending the nick to the server.\n" );
  sprintf( line, "nick %s\n", nick );
  writeln( sockfd, line, strlen( line ) );

  if ( sockfd > *highfd )
    *highfd = sockfd;

  if ( DEBUG )
    printf( "PROC new_bot: exiting new_bot.\n" );

  return NEW_BOT;
}















