#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>
#include "config.h"
#include "socket.h"


/* 
   PROCEDURE int get_socket (serv_name, port_num)
   INPUTS: 
      serv_name   string name of a server (e.g. "csa.bu.edu")
      port_num    port number of the server (e.g. 6667)
   EFFECTS:
      establishes a socket stream connection with the server.
      Returns the socket fd if the connection is succesfully established.
      Returns NO_SERVER (-1) if the server named by serv_name does not exist.
      Returns CANT_OPEN_SOCK (-2) if a socket cannot be opened.
      Returns CON_REFUSED (-3) if the procedure can't connect to the server.
*/

int get_socket (serv_name, port_num)
     char *serv_name;
     unsigned short int port_num;
     
{
  struct hostent *serv_entry;
  struct sockaddr_in serv_addr;
  int sockfd;

  /* Get IP address of named server */
  if ( DEBUG )
    printf( "PROC get_socket: getting IP address of server %s\n", serv_name );
  if ( ( serv_entry = gethostbyname ( serv_name ) ) == NULL )
    {
      if ( DEBUG )
	printf( "PROC get_socket: Server does not exist: %s\n", serv_name);
      return NO_SERVER;
    }

  /* Initialize socket address of the server */
  if ( DEBUG )
    printf( "PROC get_socket: initializing the socket address of server.\n" );
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons( port_num );
  bcopy( serv_entry->h_addr, (char *) &( serv_addr.sin_addr ),
	  serv_entry->h_length );

  /* Establish socket connection */
  if ( ( sockfd = socket( AF_INET, SOCK_STREAM, 0 ) ) < 0 )
    {
      if ( DEBUG )
       printf( "PROC get_socket: Socket cannot be opened.\n" );
      return CANT_OPEN_SOCK;
    }
  if ( connect( sockfd, &serv_addr, sizeof serv_addr ) < 0 )
    {
      if ( DEBUG )
	printf( "PROC get_socket: Cannot connect to server: %s\n", serv_name);
      return CON_REFUSED;
    }
  
  if ( DEBUG )
    {
      printf( "PROC get_socket: Successfully connected to server: %s\n", serv_name );
      printf( "PROC get_socket: Socket number is %d\n", sockfd );
    }
  return sockfd;
} 


/*
  PROCDURE void readln ( sockfd, buff, buffln )
  INPUTS:
     sockfd     the socket fd
     buff       a pointer to a character array for the input
     buffln     the length of the array buff
  MODIFIES:
     buff
  EFFECTS:
     Reads a line from the socket connection identified with sockfd.
     The input is put into the character array buff.  
     Returns the length of the line which was read.
     Returns READ_ERR (-1) if there is an error while reading.
*/

int readln ( sockfd, buff, buffln )
     int sockfd;
     char *buff;
     int buffln;

{
  int count, len_of_line=1;

  /* Find out how long the line is */
  if ( recv( sockfd, buff, buffln, MSG_PEEK ) < 1 )
    {
      perror( "PROC readln" );
      return ( -1 ); 
    }
  for( count = 0; ( buff[count] != '\n' ) && ( count < ( buffln - 2 ) );
       count++, len_of_line++ );

  /* Now read the line and put an \0 character at the end of it. */
  if ( recv( sockfd, buff, len_of_line, 0 ) < 1 )
    {
      perror( "PROC readln" );
      return( -1 );
    }

  buff[len_of_line] = '\0';

  return len_of_line;

}


/*
  PROCDURE int writeln ( sockfd, buff, buffln )
  INPUTS:
     sockfd     the socket fd
     buff       a pointer to a character array for the output
     buffln     the length of the string to be printed
  REQUIRES:
     buffln must be smaller than the size of the array buff
  MODIFIES:
     buff
  EFFECTS:
     Writes a line of output to the socket connection with identification
     number sockfd.  The output is read from the array pointed to by buff.
     Returns the length of the line which was written.
     Returns WRITE_ERR (-1) if there is an error while writing.
*/

int writeln ( sockfd, buff, buffln )
     int sockfd;
     char *buff;
     int buffln;

{
  if ( DEBUG )
    {
      printf( "PROC writeln: this is the buffer\n" );
      printf( "PROC writeln: %s", buff );
      printf( "PROC writeln: the bufflen is %d\n", buffln);
      printf( "PROC writeln: the sockfd is %d\n", sockfd);
    }
  if ( send( sockfd, buff, buffln, 0 ) <= 0 )
    {
      if ( DEBUG )
	printf( "PROC writeln: Error in writing line to socket.\n" );
      return ( -1 );
    }
  
  return buffln;

}




