/************************************************************
* MrsBot by Hendrix <jimi@rahul.net>                        *
* config.h                                                  *
*   Global definitions obtained by including this file.     *
************************************************************/
/* There are 3 options : CLION, CHORSE or CSHELL  */
/* You need to choose option that you want.       */
/* If you compile 3 times with 3 options above,   */
/* you will have 3 bots that can mass deop a      */
/* channel in suck a way that no one can react .  */
/* the default command character is ,             */
/* You can fix this by editing the file public.c  */

#define CLION

#define SERV "alfred1.u.washington.edu"          /* Default server to use */
#define MASTER "Memoirs"
#define HOME "#DeJavu"
#define HOST "trtnguye@galaxy.csc.calpoly.edu"  

/* Definitions from Adam Roach's bot skeleton. */
#ifdef CLION
#define NICK "ExBot"
#define USER "tdang"
#define NAME "tdang"  /* Bot's IRCNAME */
#define BABYNAME "ExBot's_Little_Helper"
#endif

#ifdef CHORSE
#define NICK "DziVang"
#define USER "tule"
#define NAME "tule"  /* Bot's IRCNAME */
#define BABYNAME "DziVang's_Little_Helper"
#endif

#ifdef CSHELL
#define NICK "HuKhong"
#define USER "tttran"
#define NAME "tttran"  /* Bot's IRCNAME */
#define BABYNAME "HuKhong's_Little_Helper"
#endif

#ifdef COTTER
#define CSHELL
#define NICK "blue4"
#define USER "trinh"
#define NAME "*LoveIsSoScaryThatTurnsUBlue*"  /* Bot's IRCNAME */
#define BABYNAME "SeaOtter's_Little_Helper"
#endif

/* Uncomment this and recompile to get a debug log file  */
/* #define DEBUGMODE */ 

/* Helper bot info as above.  Helper bot nicks are in serverif.c */

/* Maximum number of reconnections to a server allowed before quitting. */
#define MAXRECONNECTS 25

/* Maximum users allowed in MrsBot's userlist */
#define MAXUSERS 100

/* Access levels for MrsBot's reactions to bans. Kinda a level of protection */
#define REMOVEONLY 666
#define REMOVENKICK 888
#define REMOVEKICKNBAN 999

/* Definitions for variable "whatneeded" from beatban.c */
#define CAN_JOIN -1
#define WANT_UNBAN 0
#define WANT_INVITE 1

/* Actions to be performed by onuserhost().  The USERHOST server message is
   used anytime we need to get the userhost for a given nickname.  These are
   the situations where we need this.  This way, when the userhost reply
   message comes back to MrsBot, she'll remember why she sent it! */
#define NORMALBAN 0
#define ADIOS 1
#define MEGABAN 2
#define UNBAN 3
#define PROTECT 4
#define UNPROTECT 5
#define SETUSER 6
#define SHOWACCESS 7

/* Definition for command record structure.  Holds a keyword and the
   function that does that command.  Used in onmsg.c and public.c.
   Also, includes access level to execute command in V2. */
struct commandrec {
  char *name;
  void (*function)();
  int access;
  };

/* Definition for a record in the list of userhosts that MrsBot
   recognizes.  Access levels range from -222 to 999 (the higher
   the better) and are used in joinkick.c, onmode.c, onmsg.c, and
   public.c */
struct userlist_rec {
  char *userhost_mask;
  int access_lev;
  char protected;
};

/* Macros for universal OS handling of signal vectors */
#define sysvhold notice
#define HOLDLEN(vec,off) (vec[off] == 0x40) 

/* Definition for information saved from a request that causes MrsBot
   to request a userhost.  Contains nick and userhost of user making
   the request, the nickname we are getting userhost on, the action to
   perform once we GET the userhost, and an additional info field that
   is currently only used with ADIOS and SETUSER. */
struct requestinfo {
  char req_nick[10];
  char req_userhost[80];
  char targetnick[10];
  char uhostaction;
  int extrainfo;
  };

/* Definition for an item on MrsBot's internal store of channel users.
   Contains nick, userhost, and op state for users that MrsBot monitors. */
struct trackrec {
  long Kludge_Key;
  char nick[10];
  char userhost[80];
  char opped;
  struct trackrec *next;
  };

/* struct chaninfo {
   char chan[20];
	struct trackrect *reclist;
	struct chaninfo *next;
};*/
/*#include <net/nh.h>
#include <sys/select.h>*/

