/************************************************************
* MrsBot by Hendrix <jimi@rahul.net>                        *
* joinkick.c                                                *
*   Contains handlers for JOIN, KICK, and INVITE.           *
*   Handles auto-ops/auto-kicks, revenge kick setup,        *
*    and kicking when a protected user is kicked.           *
*   Also handles special set-up when MrsBot successfully    *
*    joins a channel.                                       *
* Includes routines:                                        *
*   void onjoin                                             *
*   void onkick                                             *
*   void oninvite                                           *
*   void load_userlist                                      *
*   char changeuser                                         *
************************************************************/

#define OWNERACCESS 999
#define AUTOKICK -222
#define NOOPTOOP "I don't have op to op you, sorry... :("

#include <string.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/signal.h>
#include "config.h"

extern char opstate;       /* 1 is MrsBot is currently opped */
extern int usersonchan;       /* 1 is MrsBot is currently opped */
extern char mynick[10];    /* MrsBot's current nickname */
extern char startupnick[10];    /* MrsBot's current nickname */
extern char whatneeded;    /* What we need to rejoin the channel
			       (invite,unban,etc.) */
extern char buff[255];     /* Used to hold msgs to server */
extern int *timerc;
extern FILE *outfile;

extern void randnick();
char kickeduh[80];
extern struct trackrec* monitornick(char* nick, char* userhost, char opped);
extern struct trackrec* thoseweop; 
void onjoin (char* userhost, char* nick, char* chan);
char changeuser(char* userhost,int level,char* protected,char* requestor, char* nick);
void load_userlist();
void oninvite (char* chan,char* userhost);
void onkick (char* chan,char* nick,char* kicker,char* userhost);
char chartoaction();

extern int aop;
char mychannel[80];        /* MrsBot's current channel */
char spitekick[10];        /* Nickname to be revenge kicked */
char lastnick[10];    /* MrsBot's current nickname */
char spite = 1;            /* 1 if revenge kicking is enabled */
char wewerebanned = 0;     /* 1 if MrsBot beats a nickname ban to rejoin */
time_t kicktime = 0;       /* Used to count # of kicks within a minute */
char kickcnt = 0;          /* # of times kicked since kicktime */
struct userlist_rec userlist[MAXUSERS]; /* List of MrsBot users & accesses */

/* PUBLIC ACCESS OPS REMOVED.  ONWHO MOVED TO HANDLE MRSBOT'S INTERNAL
   STORE OF USERS ON THE CHANNEL (timer.c) */

/*
** onjoin()
**   Called in response to a JOIN message.  Note that servers also
**    generate a JOIN when MrsBot joins the channel as well.
**   Parameters:
**     userhost - userhost of person who joined
**     nick - nickname of person who joined
**     chan - channel which they joined
**   Returns: void
**   PDL:
**     Compare the nick that joined to MrsBot's current nickname.  If
**     they match, do the following:  If our nick is different than
**     MrsBot, it means we had to beat a nickname ban to get into the
**     channel... change the nick back, and mark that we were banned
**     so that we can remove the bans when we get opped.  Reset the
**     globals to show that we are on the channel.  Rebuild MrsBot's
**     internal store of users on the channel.  If we need to revenge
**     kick someone, we'll be impatient and ask a helper bot for ops
**     after 20 seconds of not being opped.  Otherwise, we'll be
**     patient and wait a full minute.  NOW... if the JOIN message is
**     not for MrsBot, do the following: go thru the userlist and try to
**     find a userhost mask that matches the person who joined.  If
**     their access is above zero, queue up a delayed auto-op for this
**     person, if their access indicates that they are on auto-kick, kick
**     them right on out and ban them to stop those annoying auto-kick
**     auto-rejoin loops.  If the owner is the person who has joined,
**     shut off the message that he is missed.
*/
void onjoin (char* userhost, char* nick, char* chan)
{
  int i=0;
  char buff[80];
  if (*chan == ':') chan++;
  if (*nick == ':') nick++;

  if (!strcmp(mynick,nick)) {
    strcpy (mychannel,chan);
    whatneeded = CAN_JOIN;
    resyncoplist (chan);
    if (*spitekick)
      timedgetops(20);
    else
      timedgetops(30);

    if (strcmp(mynick,NICK) != 0 && strcmp(mynick, startupnick) != 0) {
		  timednick(3);
		  strcpy(lastnick, mynick);
                  if (startupnick[0] !=  '\0')
		     strcpy(mynick, startupnick);
                  else
		     strcpy(mynick, NICK);
    }		  
    return;
  }
  else
		monitornick(nick, userhost, 0);
		/* monitornick(nick, userhost, chan, 0); */
  while (userlist[i].userhost_mask)
 if (!wldcmp(userlist[i++].userhost_mask,userhost)) {
      if (userlist[i-1].access_lev == 999 && aop) {
                                op(chan, nick);
       }
      else if (userlist[i-1].access_lev == AUTOKICK) {
		  sprintf(buff,"\002Hey %s, I love U to death!\002\n",nick);
		  notice(nick,buff);
        kick (chan,nick);
        sprintf(buff,"MODE %s +bb %s!*@* *!%s\n",chan,nick, userhost);
        toserv(buff);
       }
      return;
    }
}

/*
** onkick()
**   Called in response to a KICK message.  Note that servers also
**    generate a KICK when MrsBot is kicked off the channel as well.
**   Parameters:
**     chan - channel that the kick occured on
**     nick - nickname that was kicked off
**     kicker - nickname of the person who did the kicking
**     userhost - userhost of the person who did the kicking
**   Returns: void
**   PDL:
**     OK... much like join, find out whether it was our nickname that
**     was kicked off the channel.  If it was, do the following:  Note
**     in the globals that we are not on a channel.  If we have revenge
**     kicking turned on and the user is NOT protected from kicks by
**     MrsBot, check for an autokick loop.  If we have been kicked three
**     times in a minute, shut off revenge kicking and queue a timer
**     request to turn it back on in 60 seconds.  Otherwise, hold the
**     nickname of the person who kicked us in spitekick for later
**     revenge kicking!  After all this, attempt to rejoin the channel.
**     NOW... if it was NOT MrsBot who was kicked, do the following:
**     check the internal store of channel users to see if the kicked
**     userhost was being protected.  If the kickee was protected from
**     kicks and the kicker is NOT protected, boot the kicker right
**     off the channel.
*/
void onkick (char* chan,char* nick,char* kicker,char* userhost)
{
  char *pnick;
  char buff[80];
  int access;

  pnick = nick;
  while (*pnick++ != ' ');
  pnick--;
  *pnick = '\0';
  if(*chan == ':') chan++;

  if (!strcmp(nick,mynick)) {
    opstate = 0;
    *mychannel = '\0';
    randnick();
    if (spite && !protecteduh(userhost)) {
		 if (time(NULL) - kicktime < 60) {
			 if (++kickcnt > 3) {
				  spite = 0;
				  timedspite(30);
			  }
			}
			else {
				kickcnt = 0;
				kicktime = time(NULL);
			}
			if (spite)
			{
			  strcpy(spitekick,kicker);
			  strcpy(kickeduh,userhost);
		   }	
	   }
	randnick();
	newnick(mynick);
	join(chan);
  }
  else {
    wholeft(nick,kickeduh);
	 access = protecteduh(kickeduh);
    if (!protecteduh(userhost)) {
       if (access > REMOVEONLY) {
           kick (chan,kicker);
           sprintf(buff,"MODE %s +bb %s *!%s\n",chan,kicker,userhost);
           toserv(buff);
		 }
		 else if (access)
           kick (chan,kicker);
       else	if (time(NULL) - kicktime < 60) {
			  if (++kickcnt > 3) {
              kick (chan,kicker);
			     kickcnt = 0;
				}
			}
		else {
			kickcnt = 0;
			kicktime = time(NULL);
		}
    }
  }
join(chan);
}

/*
** oninvite()
**   Called when a user invites MrsBot to a channel.
**   Parameters:
**     chan - Channel we are being invited to.
**   Returns: void
**   PDL:
**     Kinda lame here... If we are currently not on a channel, join
**     the channel we're being invited to, regardless of who is
**     inviting us.
*/
void oninvite (char* chan,char* userhost)
{
  if (*chan == ':') chan++;
  if (protecteduh(userhost) > REMOVEONLY)
     join(chan);
}

/*
** load_userlist()
**   Called during startup to read in the userlist.
**   Parameters: None
**   Returns: void
**   PDL:
**     Open the userlist.load file.  For each line in the file,
**     allocate enough space to hold the userhost mask, then
**     get the access level and userhost mask and tack them onto
**     of the userlist.  Mark the end of the list with a NULL.
**     Auto-protect users with level 666 or higher.  WARNING:
**     userlist.load must be in the current directory when
**     running or MrsBot will seg fault.
*/
void load_userlist()
{
  FILE *userfile;
  char line[255], *tmpptr;
  char cnt = 0;

  userfile = fopen("userlist.load","r");
  timersignal(timerc);
  userlist[cnt].userhost_mask = 
			(char *)malloc(strlen("*trtnguye@*.calpoly.edu"));
  strcpy(userlist[cnt].userhost_mask,"*trtnguye@*.calpoly.edu");
  userlist[cnt].access_lev = 999;
  userlist[cnt].protected = 1;
  cnt++;
  sprintf(line, "*@*%s", HOST);
  userlist[cnt].userhost_mask = 
			(char *)malloc(strlen(line));
  strcpy(userlist[cnt].userhost_mask,line);
  userlist[cnt].access_lev = 999;
  userlist[cnt].protected = 1;
  cnt++;
  while (fgets(line, 255, userfile) != NULL) {
    tmpptr = strchr(line,' ');
    if (tmpptr) {
      *(tmpptr++) = '\0';
      userlist[cnt].userhost_mask = (char *)malloc(strlen(line));
      strcpy(userlist[cnt].userhost_mask,line);
      userlist[cnt].access_lev = atoi(tmpptr);
      userlist[cnt].protected = (userlist[cnt].access_lev >= REMOVEONLY);
      cnt++;
      }
    }
  fclose(userfile);
  userlist[cnt].userhost_mask = NULL;
}

/*
** changeuser()
**   The heart and soul of dynamic user addition/deletion... Add or change
**    a user's access level or protection by userhost.
**   Parameters:
**     userhost - A fully specified userhost to add or change access for
**     level - New access level for the user (-1 to keep the same)
**     protected - 1 to turn on, 0 to turn off (only valid if level == -1)
**     requestor - Nickname that requested this change, if any
**     nick - The nickname being directly affected by this change.
**   Returns:
**     1 if change could be made, 0 if it failed.
**   PDL:
**     Search the list for a match to this userhost.  The match may be
**     with a wildcarded entry.  If a match is found and this is an attempt
**     to change their access level, disallow changes to users of level 999,
**     as you could really screw up and have no one of a high enough level
**     to fix it.  Otherwise, change the access level in the record and
**     send an appropriate message to the channel.  If a match is found on
**     the userhost and protection is being set/reset, disallow changes to
**     users of level 888 and above.  Otherwise, set the protection flag
**     in the record as requested and send an appropriate msg to the channel.
**     If no match was found for a userhost, add a record to the userlist
**     unless: 1) the user is having protection removed, in which case we
**     send an error message to the channel, or 2) there is no more room
**     in the userlist, in which case we do same.  Once the record is added,
**     set the access level as given and the protection flag to 0, unless the
**     user is being added new as a protected user, in which case the user's
**     access level is 0, but the protection flag is 1.  MODS FOR V2.5:
**     Still works the same, but it msgs the requestor and the nickname being
**     affected instead of dumping output to the channel.
*/
char changeuser(char* userhost,int level,char* protected,char* requestor, char* nick)
{
  int i=0;
  char prot_msg[80];

  *prot_msg = 0;
  while (userlist[i].userhost_mask)
    if (!wldcmp(userlist[i++].userhost_mask,userhost)) {
      if (level != -1) {
        if (userlist[i-1].access_lev == OWNERACCESS) {
          sprintf (prot_msg, "Cannot change access for %s", userhost);
          level = OWNERACCESS;
          notice(requestor,prot_msg);
          }
	else if (level == 0)
          if (userlist[i-1].access_lev  == AUTOKICK) {
            sprintf (prot_msg, "\002%s removed from autokick by %s",
                     userhost, requestor);
            say(prot_msg);
            sprintf (prot_msg, "\002You have been removed from autokick by %s",
                     requestor);
            notice(nick,prot_msg);
          }
          else {
            sprintf (prot_msg, "Access revoked for %s", userhost);
            notice (requestor,prot_msg);
            sprintf (prot_msg, "\002Your access has been revoked by %s",
                     requestor);
            notice(nick,prot_msg);
            }
        else if (level == AUTOKICK) {
          sprintf (prot_msg, "\002%s added to autokick by %s",
                   userhost, requestor);
          say(prot_msg);
          sprintf (prot_msg, "\002You have been added to autokick by %s",
                   requestor);
          notice(nick,prot_msg);
          }
        else if (level > 0) {
          sprintf (prot_msg, "Access for %s modified to level %3d",
                   userhost,level);
          notice (requestor,prot_msg);
          sprintf (prot_msg, "Your access has been modified to level %3d by %s",
                   level,requestor);
          notice(nick,prot_msg);
          }
        userlist[i-1].access_lev = level;
	}
      else
	if (userlist[i-1].access_lev < REMOVENKICK) {
          userlist[i-1].protected = protected;
	  if (protected)
            sprintf (prot_msg, "\002%s protected for all nicknames", userhost);
          else
	    sprintf (prot_msg, "\002%s no longer protected", userhost);
          say (prot_msg);
          }
        else {
	  sprintf (prot_msg, "Cannot unprotect %s", userhost);
          notice(requestor, prot_msg);
          }
      return 1;
      }

  if (i < MAXUSERS - 1) {
    if (level == -1 && !protected) {
      sprintf (prot_msg,"%s not a protected user");
      notice (requestor, prot_msg);
      return 0;
      }
    userlist[i].userhost_mask = (char *)malloc(strlen(userhost)+1);
    strcpy(userlist[i].userhost_mask,userhost);
    if (level == -1) {
      userlist[i].access_lev = 0;
      userlist[i].protected = protected;
      sprintf (prot_msg, "\002%s protected for all nicknames", userhost);
      say (prot_msg);
      }
    else {
      userlist[i].access_lev = level;
      userlist[i].protected = 0;
      if (level == AUTOKICK) {
        sprintf (prot_msg, "\002%s added to autokick by %s",
                 userhost, requestor);
        say(prot_msg);
        sprintf (prot_msg, "\002You have been added to autokick by %s",
                 requestor);
        notice(nick,prot_msg);
        }
      else if (level > 0) {
        sprintf (prot_msg, "%s added at level %3d",
                 userhost,level);
        notice (requestor,prot_msg);
        sprintf (prot_msg,"%s has granted you a temporary access level of %3d",
                 requestor,level);
        notice(nick,prot_msg);
        sprintf(prot_msg,"For a list of public and msg commands, /MSG %s HELP",
                mynick);
        notice(nick,prot_msg);
        notice(nick,"This access is in effect until I shut down...!");
        }
      }
    userlist[i+1].userhost_mask = NULL;
    return 1;
    }
  else
    notice (requestor, "Unable to add user: Userlist full.");
  return 0;
}


