/************************************************************
* MrsBot by Hendrix <jimi@rahul.net>			    *
* onmode.c						    *
*   Handles MrsBot's responses to all mode changes.         *
*   Handles activation/deactivation of protection	    *
*   Manages list of protected users.			    *
* Includes routines:					    *
*   void onmode 					    *
*   void onbans 					    *
*   void ondeop 					    *
*   void onop						    *
*   char addprotect					    *
*   void rmprotect					    *
*   void showprotect					    *
*   void unban						    *
*   char protecteduh					    *
*   char splitban					    *
************************************************************/

#define NICK_ONLY 0
#define NICK_USERHOST 1
#define USERHOST_ONLY 2

#include <string.h>
#include <strings.h>
#include <stdio.h>
#include <malloc.h>
#include "config.h"

extern int noshareop;
extern struct trackrec *thoseweop;
extern char mynick[10];    /* MrsBot's current nickname */
extern char Nick[10];    /* MrsBot's current nickname */
extern char lastnick[10];    /* MrsBot's current nickname */
extern char kickeduh[80];    /* MrsBot's current nickname */
extern char buff[255];	   /* Used to hold msgs to server */
extern char spitekick[10]; /* Nickname to be revenge kicked */
extern char wewerebanned;  /* 1 if MrsBot beats a nickname ban to rejoin */
extern struct userlist_rec userlist[MAXUSERS]; /* List of MrsBot users */
extern char *whodeopped(char* nick);
extern char *whoopped(char* nick);
extern void rm_dop(char* userhost, char* nick);
extern void rm_mdkickeduh(char* userhost);
extern FILE *outfile;

char banned[4][80];	   /* List of users banned by a single MODE msg */
char deopped[4][10];	   /* List of users deopped by a single MODE msg */
char newopped[4][10];	   /* List of users opped by a single MODE msg */
char opstate = 0;	   /* 1 is MrsBot is currently opped */
int level = 0;


void onmode(char* mode,char* chan,char* params,char* nick,char* userhost);
void ondeopban(int numdeops,int numbans, char* chan,char* nick,char* userhost);
void onop(int numops,char* chan, char* nick, char* userhost);
char addprotect(char* userhost,char* requestor,char* nick);
void rmprotect(char* userhost,char* requestor,char* nick);
void showprotect(char* nick);
void unban(char* chan,int numbans);
int protecteduh(char* userhost);
char splitban(char* fullban,char* nickpart,char* uhpart);
char isnickpro(char* nick);

/*
** onmode()
**   Called in response to a mode change on MrsBot's channel.  Yeah,
**    I went gung-ho parsing the whole message, but I got sick of the
**    1 million ways people try to camoflauge their bans and deops!
**   Parameters:
**     mode - The part of the mode change showing what modes are being
**	      changed (e.g. "+bb-o")
**     chan - The channel affected by this mode change
**     params - Nicknames/ban masks used in this mode change.
**     nick - Nickname of person who changed the mode.
**     userhost - Userhost of person who changed the mode.
**   Returns: void
**   PDL:
**     This is how you parse, baby... Step thru each character in the
**     mode, on + or -, flipflop the adding or removing mode counter,
**     on b, o, or l, use the next parameter in the param list as the
**     parameter for this action.  MrsBot then tracks all deops, ops,
**     and added bans in the mode command and calls the appropriate
**     handlers for each.
*/
extern int efn;
extern int eb;
void onmode(char* mode,char* chan,char* params,char* nick,char* userhost)
{
   char adding=0;
   int deops=0;
   int yes = 0;
   int newops=0;
   int bans=0;
   int unbans=0;
   char buff[80];
   char *object;
   char *temp = mode;

   level = protecteduh(userhost);
   object = strtok(params," ");
   while (*temp)
   {
      switch (*temp++)
      {
				case '+':
				  adding = 1;
				  break;
				case '-':
				  adding = 0;
				  break;
				case 'b':
				  if (adding)
				  {
					 strcpy(banned[bans++],object);
				  }
				  else if (eb && level < 999 && !unbans && isnickopped(nick))
				  {
					     sprintf(buff, "MODE %s -o %s\n", chan, nick);
					     toserv(buff);
						  unbans++;
				  }
				  object = strtok(NULL," ");
				  break;
				case 'o':
				  if (adding)
				  {
					  strcpy(newopped[newops++],object);
				  }
				  else
				  {
					  strcpy(deopped[deops++],object);
				  }
				  object = strtok(NULL," ");
				  break;
				case 'l':
				  if (adding)
				  {
					  sprintf(buff, "MODE %s -l\n", chan);
					  toserv(buff);
			     }
				  object = strtok(NULL," ");
				  break;
				case 'k':
				  if (adding && level < 999)
				  {
					  kick(chan, nick);
					  sprintf(buff, "MODE %s -k %s\n", chan, object);
					  toserv(buff);
			     }
				  object = strtok(NULL," ");
				  break;
				case 's':
				  if (adding && efn && level < 999)
				  {
					  sprintf(buff, "MODE %s -s\n", chan);
					  toserv(buff);
			     }
				  break;
				case 'p':
				  if (adding && efn && level < 999)
				  {
					  sprintf(buff, "MODE %s -p\n", chan);
					  toserv(buff);
			     }
				  break;
				case 'i':
				  if (adding && efn && level < 999)
				  {
					  sprintf(buff, "MODE %s -i\n", chan);
					  toserv(buff);
			     }
				  break;
				case 'm':
				  if (adding && efn && level < 999)
				  {
					  sprintf(buff, "MODE %s -m\n", chan);
					  toserv(buff);
			     }
				  break;
            default:
					break;
			  }
    }
	if (deops || bans) 
		ondeopban(deops, bans, chan, nick, userhost);
   if (newops)
      onop(newops,chan,nick,userhost);
}

void ondeopban(int numdeops,int numbans, char* chan,char* nick,char* userhost)
{
  int i, j;
  char buff[256];
  char *deoppeduh;
  int  ReopCount = 0;
  int  ReopPos[4];
  int  UnBanCount = 0;
  int  UnBanPos[4];
  int  iskicked = 0;
  int  beenbanned = 0;
  int  ismassdeopped = 0;
  char uhostpart[80],nickpart[10],bantype;

  if(numdeops > 1 && level < 777)
  {
		 kick(chan, nick);
		 iskicked++;
  }
  for (i=0;i<numdeops;i++)
  {
     if (!strcmp(deopped[i],mynick))
     {
			opstate = 0;
     }
     else
     {
			deoppeduh = whodeopped(deopped[i]);
			if (protecteduh(deoppeduh))
			{
				if (strcmp(nick,mynick) != 0 && level < 999 && !iskicked)
            {
					kick(chan,nick);
					iskicked++;
             }
				 ReopPos[ReopCount] = i;
				 ReopCount++;
			}
     }
  }
  /* for (i=0;i<numbans && strchr(nick, '.')== NULL;++i) */
  for (i=0;i<numbans;++i)
  {
    bantype = splitban(banned[i],nickpart,uhostpart);
    if (bantype != USERHOST_ONLY)
    {
       if (uh_nick_protected(nickpart,uhostpart))
       {
				UnBanPos[UnBanCount] = i;
				UnBanCount++;
			   if (!level && opstate)
			   {
			  	  kick(chan,nick);
				  ++iskicked;
			   }
       }
    }
    else
    {
       j= -1;
       while (userlist[++j].userhost_mask)
       {
			  if (userlist[j].protected)
			  {
				  if (bancmp(uhostpart,userlist[j].userhost_mask))
					  continue;
				  UnBanPos[UnBanCount] = i;
				  UnBanCount++;
				  if (userlist[j].access_lev >= REMOVENKICK && !iskicked )
				  {
					  if (!level && opstate)
					  {
						  kick(chan,nick);
						  ++iskicked;
					  }
				  }
				  if (userlist[j].access_lev >= REMOVEKICKNBAN && !beenbanned)
				  {
					  if (!level && opstate)
					  {
							sprintf (buff,"MODE %s -o+b %s *!%s\n", chan,nick,userhost);
							toserv (buff);
						  ++beenbanned;
					  }
			      }
			     break;
	        }
       }
		 }
  }
  if (ReopCount && !numbans)
  {
		  sprintf(buff, "MODE %s +", chan);
		  for (i=0; i < ReopCount; i++) 
			  strcat(buff, "o");
		  for (i=0; i < ReopCount; i++) 
		  {
			  strcat(buff, " ");
			  strcat(buff, deopped[ReopPos[i]]);
        }
		  strcat(buff, "\n");
		  toserv (buff);
  }
  else if (UnBanCount && !numdeops)
  {
		  sprintf(buff, "MODE %s -", chan);
		  for (i=0; i < UnBanCount; i++) 
			  strcat(buff, "b");
		  for (i=0; i < UnBanCount; i++) 
		  {
			  strcat(buff, " ");
			  strcat(buff, banned[UnBanPos[i]]);
		  }
		  strcat(buff, "\n");
		  toserv (buff);
  }
	  else if (UnBanCount && ReopCount)
	  {
	     sprintf(buff, "MODE %s +", chan);
		  for (i=0; i < ReopCount; i++) 
			  strcat(buff, "o");
        strcat(buff, "-");
		  for (i=0; i < numbans; i++) 
			  strcat(buff, "b");
		  for (i=0; i < ReopCount; i++) 
		  {
			  strcat(buff, " ");
			  strcat(buff, deopped[ReopPos[i]]);
		  }
		  for (i=0; i < numbans; i++) 
		  {
			  strcat(buff, " ");
			  strcat(buff, banned[i]);
		  }
		  strcat(buff, "\n");
		  toserv (buff);
	  }
}


/*
** onop()
**   Called with a list of users opped in a single mode change.
**   Parameters:
**     numops - Number of users opped in this mode change.
**     chan - Channel the users were opped on.
**   Returns: void
**   PDL:
**     Most of this code is for MrsBot herself being opped.  If one
**     of the opped users is MrsBot, set our opstate to TRUE.  Then
**     check to see if we have a revenge kick pending.	If so, boot
**     them.  Then check if we have recenetly beaten a nickname ban
**     by changing nicknames.  If so, remove the nickname bans which
**     affect MrsBot.  If the person being opped is not MrsBot, update
**     the internal store of channel users to show the new op state
**     of this user.  If it is a helper bot, and we are deopped, wait
**     10 seconds to see if we are opped, then ask the bot for ops.
*/
void onop(int numops,char* chan,char *nick, char *userhost)
{
  int i, j;
  char ban_mask[80];
  char* oppeduh;

  if ( strchr(nick, '.')!= NULL) 
  { 
	   sprintf(ban_mask,"MODE %s -", chan);
		for (i=0; i < numops; i++)
			strcat(ban_mask, "o");
		for (i=0; i < numops; i++)
		{
         strcat(ban_mask, " ");
         strcat(ban_mask, newopped[i]);
	   }
	  strcat(ban_mask, "\n");
	  toserv(ban_mask);
   }
	else if ( opstate && noshareop && level < 999) {
	  j = 0;
	  sprintf(ban_mask,"MODE %s -", chan);
	  for (i=0;i<numops;++i)
	  {
		 if (strcmp(mynick, newopped[i]) != 0) {
			 strcat(ban_mask,"o");
			 j++;
		 }
     }
	  for (i=0;i<numops;++i)
	  {
		 if (strcmp(mynick, newopped[i]) != 0) {
		    strcat(ban_mask, " ");
			 strcat(ban_mask, newopped[i]);
		 }
     }
	 if (j) {
		  strcat(ban_mask, "\n");
		  toserv(ban_mask);
		  }
    	  sprintf(ban_mask,"MODE %s -o %s\n", chan, nick);
		  toserv(ban_mask);
	}
	else {

	  for (i=0;i<numops;++i)
	  {
		 if (!strcmp(newopped[i],mynick) || !strcmp(newopped[i], NICK) ||
		     !strcmp(newopped[i],lastnick) )
		 {
			opstate = 1;
			if (*spitekick)
			{
				 kick(chan, spitekick);
				 rm_mdkickeduh(kickeduh);
				 *spitekick = '\0';
				 *kickeduh = '\0';
			}
			if (wewerebanned)
			{
				  strcpy(ban_mask,Nick);
				  strcat(ban_mask,"!");
				  strcat(ban_mask,USER);
				  strcat(ban_mask,"@");
				  strcat(ban_mask,HOST);
				  clearbans(ban_mask);
				  wewerebanned = 0;
			}
		 }
		 else
			  oppeduh = whoopped(newopped[i]);
     }
  }
}

/*
** addprotect()
**   Dynamically adds a userhost to the list of protected userhosts.
**   Parameters:
**     userhost - Userhost to add to the list.
**   Returns:
**     1 if the user was successfully added, 0 if not.
**   PDL:
**     Easy for version 2:  Call changeuser to modify/add this user's
**     entry in the userlist to have protect set to 1.	The -1 for
**     level indicates that the access level for this user should
**     not be changed.	If the user is added, it is at level 0.
*/
char addprotect(char* userhost,char* requestor,char* nick)
{
  changeuser(userhost,-1,1,requestor,nick);
}

/*
** rmprotect()
**   Dynamically removes a userhost from the list of protected userhosts.
**   Parameters:
**     userhost - Userhost to add to the list.
**   Returns: void
**   PDL:
**     Easy for version 2:  Call changeuser to modify/add this user's
**     entry in the userlist to have protect set to 0.	The -1 for
**     level indicates that the access level for this user should
**     not be changed.
*/
void rmprotect(char* userhost,char* requestor,char* nick)
{
  changeuser(userhost,-1,0,requestor,nick);
}

/*
** showprotect()
**   Sends a representation of the protect list to the given nickname.
**   Parameters:
**     nick - Nickname to receive the copy of the protect list.
**   Returns: void
**   PDL:
**     Go thru the list and message each protected userhost to the
**     nick, with a note appended for users protected with "kick
**     & ban when banned" or "kick when banned".
*/
void showprotect(char* nick)
{
  int i= -1;
  char prot_msg[200];

  msg (nick,"Access userhost list:");
  while (userlist[++i].userhost_mask)
  {
      sprintf(prot_msg,"%-40s %4d", userlist[i].userhost_mask,userlist[i].access_lev ); 
		msg(nick,prot_msg);
  }
}

/*
** unban()
**   Builds a MODE -bbb command for bans and sends it to the server.
**   Parameters:
**     chan - Channel to remove bans from
**     numbans - Number of bans being removed.
**   Returns: void
**   PDL:
**    Build the "-bbb" string by concatenating the number of b's that
**    numbans denotes.	Concatenate the list of bans in banned to the
**    MODE command, then send it to the server.
*/
void unban(char* chan,int numbans)
{
  char buff[255];
  int i;

  sprintf(buff,"MODE %s -", chan);
  for (i=0; i<numbans; ++i)
    strcat(buff,"b");
  for (i=0; i<numbans; ++i) {
    strcat(buff," ");
    strcat(buff,banned[i]);
  }
  strcat(buff,"\n");
  toserv(buff);
}

/*
** protecteduh()
**   Checked if a given userhost is on the protected list.
**   Parameters:
**     userhost - Userhost to check
**   Returns:
**     Protection level for this user (REMOVEONLY, REMOVENKICK,
**	or REMOVEKICKNBAN)
**   PDL:
**     Search the list for the userhost. If we find it and it is
**     protected, return the access level (which will translate
**     into the values above), unless the user is below the
**     protection level (meaning someone else protected them),
**     then their level is assumed to be REMOVEONLY.
*/
int protecteduh(char* userhost)
{
  int j = -1;
  char *tmpptr;

  if (userhost)
  {
     while (userlist[++j].userhost_mask)
		 {
			if (!wldcmp(userlist[j].userhost_mask,userhost))
			{
				if (userlist[j].protected)
					return (userlist[j].access_lev);
				else
				return 0;
	       }
     }
  }
  return 0;
}

/*
** splitban()
**   Splits a ban into it nickname and userhost parts.	Also,
**    determines the "type" of ban it is.
**   Parameters:
**     fullban - The ban to split.
**     nickpart - Area to return the nickname part of the ban.
**     uhpart - Area to return the userhost part of the ban.
**   Returns:
**     The "type" of ban: NICK_ONLY, USERHOST_ONLY, or NICK_USERHOST.
**   PDL:
**     Assume the ban is USERHOST_ONLY.  Copy the ban from fullban
**     until the ! is reached.	Copy the remainder of fullban into
**     uhpart.	Check the nickname part for characters other than *.
**     If one is found, then this is considered a nickname ban.  Now
**     check the uhpart against *@*.  If *@* is the userhost part,
**     the ban is NICK_ONLY, otherwise it is NICK_USERHOST.
*/
char splitban(char* fullban,char* nickpart,char* uhpart)
{
  char *tmp,bantype;

  bantype = USERHOST_ONLY;
  tmp = nickpart;
  while (*fullban && *fullban != '!')
    *(tmp++) = *(fullban++);
  *tmp = '\0';
  if (*fullban) {
    ++fullban;
    strcpy(uhpart,fullban);
    while (*nickpart)
      if (*(nickpart++) != '*') {
   if (strcmp(uhpart,"*@*"))
     bantype = NICK_USERHOST;
	else
     bantype = NICK_ONLY;
   break;
   }
    }
  else
    *uhpart = '\0';
  return bantype;
}

char isnickpro(char* nick)
{
  struct trackrec *tmpptr;

  tmpptr = thoseweop;
  while (tmpptr) {
    if (!wldcmp(nick,tmpptr->nick) )
		 if (protecteduh(tmpptr->userhost)) 
	       return 1;
       else
			 return 0;
    tmpptr = tmpptr->next;
  }
  return 0;
}




