/************************************************************
* MrsBot by Hendrix <jimi@rahul.net>                        *
* public.c                                                  *
*   Handles all responses to things said on the channel.    *
*   Handles SING, DANCE, and RAP commands.                  *
* Includes routines:                                        *
*   void onpublic                                           *
*   void parsepublic                                        *
*   void pub_sing                                           *
*   void pub_dance                                          *
*   void pub_rap                                            *
*   int hash_func                                           *
*   void findsong                                           *
*   void printlyric                                         *
*   void initsongs                                          *
*   void abbrevcmd                                          *
*   void onctcp                                             *
************************************************************/

#define SEPARATORS " .,;:?" /* Breaks between words */

#include <string.h>
#include <strings.h>
#include <stdio.h>
#include "config.h"

extern char mynick[10];    /* MrsBot's current nickname */
extern char mychannel[80]; /* MrsBot's current channel */

void onpublic (char* nick, char* userhost, char* text);
void abbrevcmd (char* text);

struct xlate_rec {
    char *pubcmd;
    char *privcmd;
    };

/* List of abbreviated commands on public and their message command
   equivalents. */
struct xlate_rec abbrevs[] = {
    {"help", "help" },      /* Level 111 */
    { "acc", "acc" },
    {"inv", "inv" },
    {"rep", "rep" },

    {"do", "do" },          /* Level 222 */
    {"k", "k" },
    {"ub", "ub" },
    {"open", "open" },
    {"op", "op"},

    {"b", "b"},   	    /* Level 333 */
    {"mb", "mb"},

    {"kb", "kb" },          /* Level 444 */

    {"pr", "pr" },          /* Level 555 */
    {"up", "up" },
    {"sp", "sp" },

    {"j", "j" },  	    /* Level 777 */
    {"say", "say" },
    {"me" , "me" },
    {"msg", "msg" },
    {"fl", "fl" },
    {"rev", "rev" },
    {"sta", "sta" },

    {"l", "l" },	   /* Level 888 */
    {"ni", "ni" },
    {"rn", "rn" },
    {"on", "on" },
    {"se", "se" },
    {"cyc", "cyc" },
    {"su", "su" },
    {"md", "md" },
    {"mo", "mo" },
    {"mk", "mk" },
    {"usr", "usr" },
    {"cm", "cm" },
    {"away", "away" },

    {"off", "off" }, 	/* Level 999 */
    {"ig", "ig" },
    {"save", "save" },
    {"ko", "ko" },
    {"aop", "aop" }, 
    {"hide", "hide" },
    {"eb", "eb" },
    {"kill", "kill" }, 
    {"term", "term" },
    {"nb", "nb" },
    {"efn", "efn" },
    {"col", "col" },
    { NULL, NULL} };

/* Buffer used to translate public abbreviations into private msg commands */
char toprivate[255];


/*
** onpublic()
**   Handler for all channel messages that come to MrsBot's channel.
**   Parameters:
**     nick - Nickname that said this
**     userhost - Userhost that said this
**     text - Text of channel public message
**   Returns: void
**   PDL:
**     Search the list of kickable strings.  If any of these strings are
**     found in this message, kick the user who said it.  If the text starts
**     with a CTRL-A, it is a CTCP to the channel, cal onctcp() to handle it.
**     If it begins with MrsBot's key character, check if it is an abbreviation
**     of a private trusted command.  If it is, call onmsg() with the message
**     command equivalent.  If not, examine the first word of the user's
**     public message.  If it is the bot's nickname, check if this is a
**     public command to MrsBot.
*/
void onpublic (char* nick, char* userhost, char* text)
{
  char *word;
  int i=0;

  if (*text == '\001') {
    return;
    }

  if (*text == ',') {
    abbrevcmd(text+1);
    if (*toprivate)
      onmsg(nick,userhost,toprivate,0);
    return;
    }

}


/*
** abbrevcmd()
**   Check a public message that started with a ',' to see if it
**    is an abbreviated command and expand it.
**   Parameters:
**     text - The text of the public message following the ','.
**   Returns: void
**   PDL:
**     Chop off the first word of the command string.  Go thru the list
**     of abbreviated commands and search for a match with this word.
**     If one is found, place the expanded command from the list into
**     toprivate and append the remainder of the command text.  This
**     then forms a command string that looks like in came in via a private
**     message, and can later be handled by onmsg().
*/
void abbrevcmd (char* text)
{
  int i = -1;
  char *rest;

  rest = strchr(text,' ');
  if (rest)
    *(rest++) = '\0';
  while (abbrevs[++i].pubcmd)
    if (!strcasecmp(abbrevs[i].pubcmd,text) ||
        !strcasecmp(abbrevs[i].privcmd,text)) {
      strcpy (toprivate,abbrevs[i].privcmd);
      if (rest) {
        strcat (toprivate," ");
        strcat (toprivate,rest);
        }
      return;
      }
  *toprivate = '\0';
}

/*
** onctcp()
**   Respond to both private and public CTCPs.
**   Parameters:
**     nick - The nickname that sent the CTCP
**     userhost - The userhost that sent the CTCP
**     text - The full text of the CTCP including the leading CTRL-A
**   Returns: void
**   PDL:
**     Skip the CTRL-A and check for the type of CTCP.  If it is a FINGER,
**     do something really smart-ass by creating a phony finger reply with
**     the userhost of the person doing the fingering, and a random number
**     of seconds of idle time.  Notice that we parse the userhost only out
**     to the first dot, because CTCP FINGER usually returns jimi@bolero
**     instead of the full userhost jimi@bolero.rahul.net.  For PING, just
**     send back a little weird message based on PONG.  FYI - using NOTICE
**     to send back generates a CTCP REPLY at the receiving end, whereas
**     using PRIVMSG generates a normal CTCP.
*/
#ifdef CTCP
void onctcp(char* nick,char* userhost,char* text)
{
  char outmsg[200];

  ++text;
  if (!strncmp(text,"FINGER",6)) {
    if (strchr(userhost,'.')) {
      *(strchr(userhost,'.')) = 0;
      sprintf(outmsg,"\001FINGER Finger This... (%s) Idle %1d seconds\001",
              userhost, (random() % 5) + 2);
      notice(nick,outmsg);
      }
    }
  else if (!strncmp(text,"PING",4))
     msg(nick,"\001PONG Sorry, I am not an IRC client\001");
  else if (!strncmp(text, "VERSION", 4))
	  notice(nick, "\001VERSION War Bot Version 1.0\001");
}
#endif
