/************************************************************
* MrsBot by Hendrix <jimi@rahul.net>                        *
* serverif.c                                                *
*   Main program is here.                                   *
*   Code to log into server and parse server commands       *
*    and call routine based on the type of message (public, *
*    private, mode change, etc.)                            *
*   Code to create and manage BabyBot here.                 *
*   Based heavily on Adam Roach's bot skeleton.             *
* Includes routines:                                        *
*   int bindsocket                                          *
*   void prnt                                               *
*   char rdpt                                               *
*   void signon                                             *
*   void pong                                               *
*   void linkclosed                                         *
*   void makebaby                                           *
*   void killbaby                                           *
*   void babyproc                                           *
*   void proc                                               *
*   void gracefuldie                                        *
*   main                                                    *
************************************************************/

/* This is based on the simple automated interface unit by Adam Roach

   You may use this code however you see fit as long as you leave this
   note and my name at the top of any program which contains any portion
   of this code. If you have any questions, send mail to
   n029gg@tamuts.tamu.edu.  There ya go Adam... I left it in, and almost
   at the top too. */

/* This has been modified to hell and back...  I kept bindsocket since I
   was too lazy to recode it.  prnt is rarely used anymore.  rdpt has
   basically been recoded (let's face it... sscanf sucks).  There's a spot
   in rdpt for two connections (the babysock stuff... this means 2 bots in
   one process) nothing's been implemented other than recoding rdpt to use
   select to wait on multiple sockets.  signon and pong have not been
   touched (if it ain't broke, don't fix it).  proc has been (necessarily)
   beefed up to be more resilient and handle most types of msgs that bots
   would be interested in.  The main remains mostly intact, but had some
   of my MrsBot specific stuff added.  No comments anywhere, so just hack
   at it...  HENDRIX */

/* OK... yet more mods.  The program now takes an optional command line
   parameter for the IP address of the server.  (Yes, that means numbers!)
   The default server is irc.caltech.edu (see variable ipaddress).  This
   meant modifying bindsocket after all.  rdpt cleaned up yet again.  No
   more segmentation faults due to lag in the middle of incoming server
   messages.  I finally finished up the 2 bots in a process, albeit a
   very minor 2nd bot.  Added makebaby, killbaby, and babyproc to handle
   these.  I/O for the second bot never makes it to the proc routine,
   since the select in rdpt cuts it off.  Also, added linkclosed to handle
   ping timeouts, bad links, etc. and be able to reconnect.  MrsBot still
   will NOT reconnect on kills.  This is by choice... if an op wants to
   kill it, then I'm not gonna send her back for more!  One last thing,
   added gracefuldie so that any future seg faults will not destroy the
   log file.  That way, I can see the msg that caused the fault... HENDRIX */

/* One last time... version 2 mods.  bindsocket has been replaced by a
   version that uses domain names instead of IP addresses.  A few more msgs
   are now handled by proc().  A few causes of seg faults have been tracked
   down and eliminated thru the timer callback stuff in here and onmsg.c.
   And finally, the command line params have changed to have 2 optional parms:
   1) the NAME of a server to use (although IP address will still work) and
   2) the name of a channel to join, WITHOUT THE #. (i.e. mrsbot hotsex)
   Nothing else changed much in here... HENDRIX */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <netdb.h>
#include "config.h"
#define PARTIAL "\001\126\105"
extern errno;              /* The Unix internal error number */
extern char spitekick[10]; /* Nickname to be revenge kicked */
extern char lastnick[10]; /* Nickname to be revenge kicked */
extern char offmsg[80]; /* Nickname to be revenge kicked */
extern char buff[255];     /* Used to hold msgs to server */
extern void alarmoff();    /* Function to call when a timer goes off */
extern int *timerc;
extern int ig;
extern int hide;
char myircname[20];           /* MrsBot's current nickname */
int launch = 0; 
int ban = 0;
int order = 0;
int bindsocket(int portnum);
void gracefuldie();
void proc(char* source, char* fctn, char* param);
void makebaby();
void pong(int sock,char* hst);
char rdpt(int sock, char* src, char* fn, char* bd);
void prnt(int sock, char* msg);
void babyproc();
void killbaby(int socket);
void linkclosed();

char *aways[] = {"so'ng bac. dda^`u cho ti`nh ta ba^'t die^.t..", "Lang thang cho*` em be^n bie^?n va('ng", "ngo*~ ti`nh dda~ xa, ngo*~ ngu*o*`i dda~ ddi", "ngo*~ ddo*`i nhu* dda~ tro.n va^`n tho*...", "cu*o*`i ddie^n da.i be^n no^~i ddau ti`nh co*`..", "na('ng ddo^? va`ng cho ma('t em tha^`n thoa.i", "ti`nh ye^u nhu* tra'i pha'...TCS", "nhatrang nga`y ve^` tre^n bie^?n xu*a.", "vie^'t chuye^.n ti`nh trong nhu*~ng chie^`u mu*a", "chie^`u mu`a thu tu*o*ng tu* nhu*~ng ha`ng du*`a..."};

char *alphaword[]= {
	"Natasaa", "LuvPery", "Nathael", "Guilleo", "ursPont",
	"Waveszz", "Uyennha", "DraCami", "Grandzz", "Flaming",
	"Cashews", "Peanuts", "Nutzzxz", "MIxNutz", "MuaPhun",
	"iEditor", "theLCAO", "Quantum", "AbIniti", "inSituz",
	"Wellszz", "Engerie", "KatKatK", "Abuquer", "Semiemp",
	"Insulat", "ircLame", "ircSoul", "SEASnet", "theBEBO",
	"Zzimarz", "Africaz", "Printer", "Liasonz", "Rainies",
	"ZerRain", "LiaThia", "CaLiaTh", "GoldFiz", "GUppies",
	"MrWhite", "MrRedRe", "MrPinkP", "MrBlack", "MrViolt",
	"MrYello", "MrOrang", "MrBlueB", "MrDarkD", "MrsWhit",
	"NdTllll", "NdTtLtL", "CafeNTt", "SeasCaf", "CafeHou",
	"Natalia", "Andreae", "Tommmmy", "Knocker", "Sunniie",
	"Dynamix", "Colison", "CafeKon", "Ugostay", "Igostay",
	"Xsation", "SunTerm", "Sensual", "LetmeSi", "Stlhere", 
   	"Andreew", "Slovake", "Peterse", "Moscowe", "RemyXOe",
	"Nhatran", "Forbide", "BluGold", "Cryiing", "Insanly",
	"lazerpr", "Luvucla", "intl346", "intl486", "intl286",
	"pentium", "IBMcomp", "damnbot", "Twobodi", "morobay",
	"moroclf", "LosOsos", "SanLuis", "Frwy101", "Freway5",
	"PacCoHi", "CaliCre", "Abstrak", "IntrodU", "Summary",
        "Beingsz", "UcLaBle", "MooreHl", "YoungHl", "Botacal",
        "PowellL", "SeaCafe", "Humanbe", "FrRoast", "wwWindy",
        "Williee", "UBeauty", "ThuVang", "BetaXzz", "AlphaXz",
        "iieuEM4", "Blue4Lv", "KmTnder", "Whiiite", "Whiteee",
        "BHgCdTe", "InGaPAl", "NdtLttT", "TnderPl", "WhyKism",
        "AoVoong", "Vanishg", "Wanderg", "KiTrang", "WhyLuvm",
        "Iluveuu", "PleazSt", "LetMeOn", "Boelter", "LetmeIn",
        "Tuliipz", "LuVvyou", "Kerchof", "Thunder", "Tornado" };
char *alphalogin[]= {
	"Ocillator", "QuantumLv", "Bruinokie", "RushRushs", "Invisible",
	"IonGauges", "Controler", "Treasurer", "ThuNhanSi", "MissUalot",
	"HateUalot", "MsgmeOkie", "AlicEhere", "Thi_Trang", "PhatTaiok",
	"YeuMaiMai", "Marlboroo", "Yogurtzzz", "IcecreamI", "IeuCoDDon",
	"LoneLover", "AliceCheE", "TrangCheE", "Distilate", "Condenser",
	"Reboilers", "ReflxRati", "AspenCheE", "Glasssess", "BrownHair", 
	"SulphurPj", "FreeOnBoa", "BlindMute", "Optimizat", "BeingLazy",
	"UrANatasa", "LuvePerry", "Nathaniel", "Guillermo", "WhyKiskme",
	"InSituuuu", "Flamingoe", "Potatoees", "AtOrbital", "AbInitioz",
	"Conductor", "Insulator", "Semconduk", "NdtNdtNdt", "ToBeToBeT",
	"RainsUcLa", "WindiUcla", "LuvMeUcla", "WhyHateme", "ToBeOrNot",
	"HackingHa", "Randomlog", "Randonnik", "TheAdamsz", "Luvoflife",
	"BohemiaRa", "Silencers", "Crocodile", "BlueVolga", "Budapestt",
	"Shanghaie", "ColdKatCo", "Fishtanks", "TiTiatedu", "Fastlanez",
	"Flamingco", "LasVegasz", "CesarPala", "Herculesz", "TiTiatWas",
	"Karterina", "GardenLuv", "UcLaMj294", "Sizes3032", "TiTiatMax",
	"AmericaEx", "VisasGold", "MasterCad", "MInieVanz", "SolarCell",
        "NdTtTtTtT", "UcLaBlueS", "MooreHall", "YoungHall", "Botanical",
        "PowellLuv", "SeasCafes", "NdtTtCafe", "FrchRoast", "WindyYard",
        "WillieeeE", "UrBeautie", "EmThuVang", "GammaXray", "BetaXRays", 
	"AlphaXRay", "IeuEmEver", "Blue4Love", "KsMTender", "LuvSydney",
        "WhiteColo", "VioletCol", "YellowCol", "RedColoCo", "BlueColoC",
	"HgCdTeGaA", "InGaPSiSi", "AlGaAsAli", "NdttttttT", "TenderPlz",
        "AoVongAov", "Vanishing", "Wandering", "KieuTrang", "WhyLuvMeH",
        "IluvUalot", "PleazStop", "LetMeInPz", "urNatalia", "BHhelllll",
	"Lovingyou", "Ontheseig", "FastLanez", "Catherine", "Christine",
	"Petersnak", "UrEyeOnly", "RainiUcLa", "Dumbassss", "Subwoofer",
	"Tulipz2ya", "LuVyoutoo", "Kerchoffz", "RoyceHall", "TornadoID" };
char mynick[10];           /* MrsBot's current nickname */
char startupnick[10];           /* MrsBot's current nickname */
char Nick[10];           /* MrsBot's current nickname */
char mylogin[20];           /* MrsBot's current nickname */
int babysock = -1;         /* Socket which BabyBot is using */
int reconnects = 0;        /* Times we have reconnected to the server */
int socknum;               /* Socket which MrsBot is using */
int quit = 0;              /* When it is 1, we quit almost immediately */
FILE *outfile;             /* Debug output file handle */
fd_set readfds,nullfds;    /* Two file descriptor sets for use with select */
char buffer[1000];         /* Buffer to hold incoming data for MrsBot */
char babybuffer[1000];     /* Buffer to hold incoming data for BabyBot */
char *buffend;             /* Marks the last used place in buffer */
char *babybuffend;         /* Marks the last used place in babybuffer */
char babybuff[100];        /* Buffer to hold outgoing data on babysock */
char serverhost[80];       /* Server MrsBot will use. Defaults to SERV. */
char defchannel[80];       /* Channel MrsBot will use.  Defaults to INCH. */
extern char mychannel[80];  /* Channel MrsBot will use.  Defaults to INCH. */
/* List of nicknames for helper bot and which one we are currently using. */
int babynickno;
char *babynick[] = {
    "MemBot", "HBJr", "EludeBot", "ImBot", "OhNoBot", NULL };

void signon(char* User);
void randnick();
void randlogin();
void beatban(char* User);
/*
** signon()
**     variable holding MrsBot's current nickname.
*/
void signon(char* User)
{
    char buff[256];
	 static int Init = 0;


	 if (User)
	 {
		 if (!Init)
          Init++;
       else
	       randnick();
		 sprintf(buff,"USER %s %s %s :%s\nNICK %s\n", 
						User, HOST , serverhost, NAME, mynick);
    }
    else
	 {
	    randnick();
		 randlogin();
		 sprintf(buff,"USER %s %s %s :%s\nNICK %s\n", 
					mylogin, HOST, serverhost, NAME, mynick);
    }
	 prnt(socknum, buff);
}

void randlogin()
{
sprintf(mylogin, "%s", alphalogin[random() % 140]);
}

void randnick()
{
    sprintf(mynick, "%s", alphaword[random() % 140]);
}

void beatban(char* User)
{
 	 close(socknum);
    socknum = bindsocket(6667);
	 signon(User);
}

/*
** bindsocket()
**   Sets up a socket and connects it to the server port 6667.
**   All new bindsocket() written by Tony Vencill, and forwarded to me
**   with glowing recommendations by Splat. :)  Anyway, this is SunOS
**   and Ultrix compatible, so no more #define ULTRIX.
*/
int bindsocket(int portnum)
{
  int plug;
  struct sockaddr_in socketname;
  struct hostent *remote_host;
  char buf [BUFSIZ];
  char s [BUFSIZ];

  /* open an inet socket */
  if ((plug = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
      printf ("error: can't assign fd for socket\n");
      exit (1);
    }

  /* lookup host */
  socketname.sin_family = AF_INET;
  if ((remote_host = gethostbyname (serverhost)) == (struct hostent *) NULL)
    {
      printf ("error: unknown host: %s\n", serverhost);
      exit (1);
    }
  (void) bcopy ((char *) remote_host->h_addr, (char *) &socketname.sin_addr,
		remote_host->h_length);
  socketname.sin_port = htons (portnum);

  /* connect socket */
  if (connect (plug, (struct sockaddr *) &socketname, sizeof socketname) < 0)
    {
      printf("Error: connect %i\n", errno);
      exit (1);
    }
  return (plug);
}

/*
** prnt()
**   Like toserv() but takes a socket number as a parameter.  This
**    makes it useful for use by both MrsBot and BabyBot.  Only
**    called from this file though.
*/
void prnt(int sock, char* msg)
{
    send(sock, msg, strlen(msg), 0);
#ifdef DEBUGMODE
      fprintf(outfile,"%s",msg);
#endif
}

/*
** rdpt()
**   Read incoming data off one of the sockets and do some preliminary parsing
**   Parameters:
**     sock - It's always socknum, which is global, so why's it here?!?
**     src - Output string which holds the nick!user@host or the server host
**           that sent this message.
**     fn - Output string that holds the type of server message this is
**          (e.g. PRIVMSG, MODE, etc.)
**     bd - The body of the server message... anything that isn't in src & fn
**   Returns:
**     1 if we successfully read a full server message from MrsBot's socket.
**   PDL:
**     Yuk... suppose I have to document this one.  Initialize the fd_sets
**     to look for incoming data on MrsBot's socket and BabyBot's socket,
**     if it is active.  Wait at the select until there is data available
**     on one of the two.  If it's BabyBot, peek at the data waiting at the
**     socket.  Grab up to the first newline (end of server message) and
**     call babyproc() to handle it.  If it's MrsBot's socket, peek at the
**     data as above, and pull out one and ONLY one full server command
**     (again the newline).  Do some seriously ugly parsing: Check the
**     first word of the server message.  If there is a dot anywhere in
**     it, then it is a normal nick!user@host or server host string.  If
**     not, it is one of the special case PING, NOTICE, or ERROR messages.
**     In any case, armed with that information, pull out the src of the
**     message (first word of the server message, unless it is one of the 3
**     mentioned above, in which case the src is null).  Pull out the fn
**     of the message (second word, or first word in the special cases).
**     And pull out the bd, which is everything else up to the newline.
*/

char rdpt(int sock, char* src, char* fn, char* bd)
{
  char *curr;
  char *rest;
  int lnth, i;

  *src = *fn = *bd = '\0';
  for (;;) {
    FD_ZERO (&readfds);
    FD_SET (sock,&readfds);
    if (babysock != -1)
      FD_SET (babysock,&readfds);
    select ((babysock != -1) ? babysock + 1 : sock + 1, &readfds, &nullfds, &nullfds, NULL);
    if (babysock != -1)
      if (FD_ISSET (babysock,&readfds)) {
        lnth = recv(babysock, babybuffend, 1, 0);
        if (lnth == 0) {
          /* killbaby(babysock); */
          babysock = -1;
          return 0;
          }
        if (*babybuffend == '\n' || babybuffend - babybuffer == 999) {
          *babybuffend = '\0';
          babybuffend = babybuffer;
	  babyproc();
	  return 0;
	  }
        else
          ++babybuffend;
        }
    if (FD_ISSET (sock,&readfds)) {
      lnth = recv(sock, buffend, 1, 0);
      if (lnth == 0) {
        linkclosed();
        return 0;
        }
      if (*buffend == '\n' || *buffend =='\015' || buffend - buffer == 999) {
        *buffend = '\0';
        buffend = buffer;
        rest = strchr(buffer,'.');
        if (!rest || strchr(buffer,' ') < rest)
          curr = buffer;
        else {
          curr = strchr(buffer,' ');
          if (curr)
            *(curr++) = '\0';
          strcpy(src, (*buffer == ':' ? buffer + 1 : buffer));
          }

        if (curr) {
          rest = strchr(curr, ' ');
          if (rest) {
            *(rest++) = '\0';
            strcpy(bd,rest);
            }
          strcpy(fn,curr);
          }
        return 1;
        }
      else
        ++buffend;
      }
    }
}

/*
** signon()
**   Send a USER and a NICK string to the server to facilitate signon.
**   Parameters: None
**   Returns: void
**   PDL:
**     What it said 4 lines above. :)  Also, initialize the internal
**     variable holding MrsBot's current nickname.
*/

/*
** pong()
**   Send back a pong to a pinging server.
**   Parameters:
**     sock - Socket being pinged
**     hst - Server doing the pinging
**   Returns: void
**   PDL:
**    Ugly, but it sends a "PONG <servername>\n" message.
*/
void pong(int sock,char* hst)
{
    order = 0;
    prnt(sock,"pong ");
    prnt(sock,hst);
    prnt(sock,"\n");
	 {
         away(aways[random() % 10]);
	 join(mychannel);
         if (hide == 1)
            {
          randnick();
          newnick(mynick);
            }
	 if (hide == 0)
 	    {
	  newnick(NICK);
	    }
        msg(MASTER, "You are my master..");
	 }
}

/*
** linkclosed()
**   Called when an error has causes the server to close our link.
**   Parameters: None
**   Returns: void
**   PDL:
**     Close the old dead socket.  If we haven't already reconnected
**     5 times, wait 5 seconds, reconnect to the server, and re-signon.
*/
void linkclosed()
{
    close(socknum);
    if (++reconnects > MAXRECONNECTS)
      quit = 1;
    else {
      sleep(5);
      socknum = bindsocket(6667);
      signon(USER);
    join(HOME);
    sprintf(buff, "MODE %s +st\n",HOME);
    toserv(buff);
      }
}

/*
** makebaby()
**   Makes another connection to the server for BabyBot.
**   Parameters: None
**   Returns: void
**   PDL:
**     Connect a new socket to the same server.  Sign the new socket on
**     as BabyBot.  Send MrsBot a message saying BabyBot is ready.
*/
void makebaby()
{
    char buff[256];

    babybuffend = babybuffer;
    babysock = bindsocket(6667);
    babynickno = 0;
    sprintf(buff,"user %s %s %s %s\nnick %s\nmode %s +i\n", USER, HOST,
	    SERV, BABYNAME, babynick[0], babynick[0]);
    prnt(babysock, buff);
}

/*
** killbaby()
**   Quits BabyBot off IRC.
**   Parameters: None
**   Returns: void
**   PDL:
**     Closing the socket is a pretty effective way of logging off. :)
**     You get a "Bad link?" at the server end, but BabyBot never joins
**     a channel anyway, so who's gonna see it?
*/
void killbaby(int socket)
{
    if (socket != -1)
      close(socket);
}

/*
** babyproc()
**   Handles processing of all server messages to BabyBot.
**   Parameters: None
**   Returns: void
**   PDL:
**     I got lazy and instead of parsing these messages, I just check for
**     key substrings in the server message.  The filter of PRIVMSG and
**     NOTICE at the beginning stop users from directly messaging these
**     key substrings to BabyBot and screwing it up.  Anyway, discard all
**     PRIVMSGs and NOTICEs.  If we get PINGed, parse out the server name
**     and PONG it back.  If we get an ERROR from the server that causes it
**     to close us out or we get killed, just close up BabyBot on this end.
**     If we get a nick collision (numeric 433), set a new random nickname.
**     As you can see, BabyBot does nothing real with incoming message, it
**     pretty much just sends things out.
*/
void babyproc()
{
    char *findptr,*tmpptr;

#ifdef DEBUGMODE
    fprintf(outfile,"%s\n",babybuffer);
#endif
    if (strstr(babybuffer,":***"))
      baby_ready();
    else if (strstr(babybuffer,"ERROR")) {
      if (!wldcmp("*closing*",babybuffer)) {
	killbaby(babysock);
        babysock = -1;
        }
      }
    else if (strstr(babybuffer,"433")) {
      if (babynick[++babynickno])
	sprintf (babybuff, "NICK %s\n", babynick[babynickno]);
      else
        sprintf(babybuff,"NICK BB%d%d\n", random() % 10, random() % 10);
      prnt(babysock,babybuff);
      }
}

/*
** proc()
**   Parse server messages based on the function and handle them.
**   Parameters:
**     source - nick!user@host or server host that sent the message
**     fctn - function for the server msgs (e.g. PRIVMSG, MODE, etc.)
**     param - The remainder of the server message
**   Returns: void
**   PDL:
**     If the source is in nick!user@host format, split the nickname off
**     from the userhost.  Split the body off from the parameter for the
**     message.  The parameter is generally either our nickname or the
**     nickname directly affected by this message.  You can kind of figure
**     the rest of the giant 'if' statement out.  Occasionally we need to
**     parse additional parameters out of the body.  To find out what all
**     the numeric messages are, check out 'numeric.h' that comes with the
**     server code.  ADDED: watch out for partial PRIVMSGs received from the
**     server... hold them up and make sure to stay synced with the timer
**     signals that may be ongoing.
*/
void proc(char* source, char* fctn, char* param)
{
    char *userhost, *body;
    char *modeparms;
    int i;

    if ((userhost = strchr(source,'!')) != NULL)
      *(userhost++) = '\0';

    if ((body = strchr(param,' ')) != NULL) {
      *(body++) = '\0';
      if (*body == ':')
        ++body;
      }
      
    if (!strcmp(fctn,"PRIVMSG")) {
        /* if(!strncmp(body,PARTIAL,3)) {
          if(!HOLDLEN(body,3) || (source = *timerc))
            sysvhold(source,timerc);
          } 
        else*/ if(*param == '#')
          onpublic(source, userhost, body);
        else
          if (!ig) onmsg(source, userhost, body, 1);
    }
    else if (!strcmp(fctn,"PING"))
        pong(socknum,param);
    else if (!strcmp(fctn,"ERROR")) {
	if (!wldcmp("*closing*",param))
	  linkclosed();
        }
    else if (!strcmp(fctn,"KILL"))
	 {
	     beatban(NULL);
		  join(mychannel);
    }
    else if (!strcmp(fctn,"JOIN"))
    {
        if (*param == ':') param++;
        onjoin(userhost, source, param);
     }
    else if (!strcmp(fctn,"PART") || !strcmp(fctn,"QUIT"))
    {
        /* printf("%s %s %s\n", fctn, source, body); */
        onpart(source);
    }
    else if (!strcmp(fctn,"WHOREPLY") || !strcmp(fctn,"352"))
        onwho(body);
    else if (!strcmp(fctn,"315")) {
	if (modeparms = strchr(body,' '))
	  *modeparms = '\0';
        onendofwho(body);
	}
    else if (!strcmp(fctn,"353")) {
	body = strchr(body,' ') + 1;
	onnames(body);
	}
    else if (!strcmp(fctn,"366"))
	onendofnames();
    else if (!strcmp(fctn,"319"))
	onwhoischans(body);
    else if (!strcmp(fctn,"401")) {
        if (modeparms = strchr(body,' '))
          *modeparms = '\0';
        onnosuchnick(body);
        }
    else if (!strcmp(fctn,"KICK"))
        onkick(param,body,source,userhost);
    else if (!strcmp(fctn,"NICK"))
        onnick(source,param);
    else if (!strcmp(fctn,"INVITE"))
        oninvite(body,userhost);
    else if (!strcmp(fctn,"MODE")) {
        modeparms = strchr(body,' ');
        *(modeparms++) = '\0';
        onmode(body,param,modeparms,source,userhost);
    }
    else if (!strcmp(fctn,"302"))
        onuserhost(body);
    else if (!strcmp(fctn,"367")) {
        modeparms = strchr(body,' ');
        *(modeparms++) = '\0';
        onbanlist(modeparms);
        }
    else if (!strcmp(fctn,"433"))
	onnicktaken();
    else if (!strcmp(fctn,"368"))
        onendofbans();
    else if (!strcmp(fctn,"473")) {
	*(strchr(body,' ')) = '\0';
        wheninvonly(body);
	}
    else if (!strcmp(fctn,"474")) {
	*(strchr(body,' ')) = '\0';
        whenbanned(body);
	}
    else if (!strcmp(fctn,"471")) {
	*(strchr(body,' ')) = '\0';
        whenchanfull(body);
	}
}

/*
** gracefuldie()
**   Called when we encounter a segmentation fault.
**   Parameters: None
**   Returns: void
**   PDL:
**     While debugging, I got so many seg faults that it pissed me off enough
**     to write this.  When dying from a seg fault, open files are not closed.
**     This means I lose the last 8K or so that was appended to the debug
**     logfile, including the thing that caused the seg fault.  This will
**     close the file before dying... Not too much more graceful, I agree.
*/
void gracefuldie()
{
#ifdef DEBUGMODE
    fclose(outfile);
#endif
    printf("Segmentation Fault.\n");
    exit(3);
}

/*
** main()
**   Duh, hey chief... What does a main do?
**   Parameters:
**     argc - Count of command line arguments
**     argv - List of command line arguments
**   Returns: When the program dies.
**   PDL:
**     Look for up to two command line arguments: first, a server name to
**     overrride the default SERV in config.h.  This is recognized by having
**     a '.' in the string, which a channel name cannot have.  Second, look
**     for a default channel to override INCH from server.h.  The channel name
**     must NOT contain a '#' (since # is tough to pass from the shell).  Set
**     up assorted things: random numbers, handlers for seg faults and timers,
**     initialize the internal stores for songs, insults, users, and helper
**     bots.  Attach MrsBot to the server, sign her on to IRC, join her up
**     to the channel, and loop through processing incoming server messages
**     until MrsBot is told to quit, is killed, or gives up reconnecting.
*/
main(argc,argv)
int argc;
char *argv[];
{
    int i;
    char buff[80];
    char source[80];
    char fctn[80];
    char body[512];
    memset(startupnick, 0, 10);
    memset(defchannel, 0, sizeof(defchannel));
    strcpy(serverhost,SERV);
         if (!launch)
    {
                 strcpy(mylogin, USER);
                 strcpy(mynick, NICK);
            strcpy(defchannel, HOME);
       strcpy(myircname,NAME);
                 launch++;
    }

    switch (argc)
         {
       case 4:
                         sprintf(defchannel, "#%s", argv[3]);
                 case 3:
                         strcpy(serverhost, argv[2]);
                 case 2:
                         if (strchr(argv[1], '.') != NULL)
                            strcpy(serverhost, argv[1]);
                         else
                       {
                       strcpy(mynick, argv[1]);
                       strcpy(startupnick, argv[1]);
                       }
    }
         strcpy(Nick, mynick);
    srandom(time(NULL));
    signal(SIGALRM,alarmoff);
    signal(SIGSEGV,gracefuldie);
    callback_init();

#ifdef DEBUGMODE
    outfile = fopen("mrsbot.log","w");
#endif

    load_userlist();
    load_helpers();
    load_adios();
    *spitekick = '\0';
    socknum = bindsocket(6667);
    FD_ZERO (&nullfds);
    buffend = buffer;

    signon(mylogin);
    if (defchannel[0] == '\0')
       join(HOME);
    else
       join(defchannel);
    sprintf(buff, "MODE %s +st\n",mynick);
    toserv(buff);
    while(!quit){
        if (rdpt(socknum, source, fctn, body)) {

#ifdef DEBUGMODE
          if (!strstr(body,PARTIAL))
            fprintf(outfile,">%s %s %s\n",source, fctn, body);
#endif

          proc(source, fctn, body);
            }
    }
         sprintf(buff,"QUIT :%s\n", offmsg);
    prnt(socknum,buff);

#ifdef DEBUGMODE
    fclose(outfile);
#endif
}

