/************************************************************
* MrsBot by Hendrix <jimi@rahul.net>                        *
* stdcmds.c                                                 *
*   Simple interfaces to send out most types of IRC messages *
*   Contains interface to msg an entire file to a user      *
* Includes routines:                                        *
*   void toserv                                             *
*   void op                                                 *
*   void kick                                               *
*   void who                                                *
*   void whois                                              *
*   void names                                              *
*   void join                                               *
*   void leave                                              *
*   void notice                                             *
*   void msg                                                *
*   void say                                                *
*   void action                                             *
*   void newnick                                            *
*   void invite                                             *
*   void get_userhost                                       *
*   void babymsg                                            *
************************************************************/

#include <stdio.h>
#include <string.h>
#include "config.h"
char buff[256];            /* Used to hold msgs to server */

extern int socknum;        /* Socket which MrsBot is using */
extern int babysock;       /* Socket which BabyBot is using */
extern char mychannel[80]; /* MrsBot's current channel */
extern FILE *outfile;      /* Debug output file handle */
extern char *int_userhost(char* nick);
extern char mynick[10];

void toserv(char* msg);
void op(char *chan,char *nick);
void babymsg(char* nick,char* msg);
void get_userhost(char* nick);
void invite(char* nick,char* chan);
void newnick(char* nick);
void action(char* msg);
void say(char* msg);
void msg(char* nick,char* msg);
void notice(char* nick,char* msg);
void leave(char* chan);
void join(char* chan);
void names(char* chan);
void whois(char* nick);
void who(char* nick);
void kick(char* chan,char* nick);
/*
** toserv()
**   Send a message to the server.  Optionally log to the debug file.
**   Parameters:
**     msg - Text of message to send to server, hopefully ending in \n.
**   Returns: void
**   PDL:
**     Just write it to MrsBot's socket.  Ain't Unix cool? :)
*/
void toserv(char* msg)
{
  send(socknum, msg, strlen(msg), 0);
#ifdef DEBUGMODE
    fprintf(outfile,"%s",msg);
#endif
}

/* The following are primitives that send messages to the server to perform
   certain things.  The names are quite self explanatory, so I am not going
   to document each.  By no means are they complex. */
void op(char *chan,char *nick)
{
  if (*chan == ':') chan++;
  sprintf(buff,"MODE %s +o %s\n", chan, nick);
  toserv(buff);
}

void kick(char* chan,char* nick)
{
  if (*chan == ':') chan++;
  sprintf(buff,"KICK %s %s :I Love You So Much!\n", chan, nick);
  toserv(buff);
}

void who(char* nick)
{
  sprintf(buff,"WHO %s\n", nick);
  toserv(buff);
}

void whois(char* nick)
{
  sprintf(buff,"WHOIS %s\n", nick);
  toserv(buff);
}

void names(char* chan)
{
  sprintf(buff,"NAMES %s\n", chan);
  toserv(buff);
}

void join(char* chan)
{
  if (*chan == ':') chan++;
  sprintf(buff,"JOIN %s\n", chan);
  toserv(buff);
}

void leave(char* chan)
{
  if (*chan == ':') chan++;
  sprintf(buff,"PART %s\n", chan);
  toserv(buff);
}

void notice(char* nick,char* msg)
{
  sprintf(buff,"NOTICE %s :%s\n", nick, msg);
  toserv(buff);
}

void msg(char* nick,char* msg)
{
  sprintf(buff,"PRIVMSG %s :%s\n", nick, msg);
  toserv(buff);
}
void say(char* msg)
{
  char *chan = mychannel;
  if (*chan == ':') chan++;
  sprintf(buff,"PRIVMSG %s :%s\n", chan, msg);
  toserv(buff);
}

void action(char* msg)
{
  char *chan = mychannel;
  if (*chan == ':') chan++;
  sprintf(buff,"PRIVMSG %s :\001ACTION %s\001\n", chan, msg);
  toserv(buff);
}

void away(char* msg)
{
  char *chan = mychannel;
  if (*chan == ':') chan++;
  sprintf(buff,"AWAY :%s\n", msg);
  toserv(buff);
}

void newnick(char* nick)
{
  sprintf(buff,"NICK %s\n", nick);
  toserv(buff);
}

void invite(char* nick,char* chan)
{
  sprintf(buff,"INVITE %s %s\n", nick, chan);
  toserv(buff);
}

/*
** get_userhost()
**   Gets the userhost for a given nickname, onuserhost() handles the
**    results.
**   Parameters:
**     nick - nickname to get the userhost for
**   Returns: void
**   PDL:
**     Changed for V2.5.  Now it checks MrsBot's internal user store
**     FIRST, to see if it can get the userhost for a nickname without
**     going to the server.  If so, it sends it to douhaction() directly.
**     If not, it does things the old-fashioned way and sends a USERHOST
**     command to the server.
*/
void get_userhost(char* nick)
{
  char *userhost;

  if (userhost = int_userhost(nick))
    douhaction (nick,userhost);
  else {
    sprintf(buff,"USERHOST %s\n", nick);
    toserv(buff);
    }
}

/*
** babymsg()
**   Sends a private message through BabyBot's socket
**   Parameters:
**     nick - Nick to send the message to.
**     msg - The text of the message to send.
**   Returns: void
**   PDL:
**     Very similar to a combination of msg() and toserv(), don't you think?
*/
void babymsg(char* nick,char* msg)
{
  sprintf(buff,"PRIVMSG %s :%s\n", nick, msg);
  if (babysock != -1)
    send(babysock, buff, strlen(buff), 0);
}
